/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.client.gui.bonus.element;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.other.GUIDarkenedBackground;
import com.fantasticsource.mctools.gui.element.text.GUILabeledTextInput;
import com.fantasticsource.mctools.gui.element.text.GUINavbar;
import com.fantasticsource.mctools.gui.element.text.GUIStringPicker;
import com.fantasticsource.mctools.gui.element.text.GUITextButton;
import com.fantasticsource.mctools.gui.element.text.GUITextSpacer;
import com.fantasticsource.mctools.gui.element.text.filter.FilterInt;
import com.fantasticsource.mctools.gui.element.text.filter.TextFilter;
import com.fantasticsource.setbonus.client.gui.bonus.element.GUIEnchantment;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EnchantmentGUI
extends GUIScreen {
    public GUIEnchantment clickedElement;
    public Enchantment enchantment;
    public int mode;
    public int level;

    public EnchantmentGUI(GUIEnchantment clickedElement) {
        this.clickedElement = clickedElement;
        this.enchantment = clickedElement.enchantment;
        this.mode = clickedElement.mode;
        this.level = clickedElement.level;
        if (this.enchantment == null) {
            this.enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.iterator().next();
            this.mode = 0;
            this.level = 1;
        }
        this.show();
        this.root.add((GUIElement)new GUIDarkenedBackground((GUIScreen)this));
        GUINavbar navbar = new GUINavbar((GUIScreen)this);
        this.root.add((GUIElement)navbar);
        GUITextButton save = new GUITextButton((GUIScreen)this, EnchantmentGUI.reformat((String)"setbonus.config.save"), (Color)Color.GREEN);
        this.root.add((GUIElement)save);
        this.root.add(new GUITextButton((GUIScreen)this, EnchantmentGUI.reformat((String)"setbonus.config.cancel"), (Color)Color.ORANGE).addClickActions(new Runnable[]{() -> ((EnchantmentGUI)this).close()}));
        this.root.add(new GUITextButton((GUIScreen)this, EnchantmentGUI.reformat((String)"setbonus.config.delete"), (Color)Color.RED).addClickActions(new Runnable[]{() -> {
            clickedElement.set(null, 0, 1);
            this.close();
        }}));
        this.root.add((GUIElement)new GUITextSpacer((GUIScreen)this));
        String[] validNames = new String[ForgeRegistries.ENCHANTMENTS.getKeys().size()];
        int i = 0;
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            validNames[i++] = (enchantment.func_190936_d() ? TextFormatting.RED : TextFormatting.GREEN) + "" + EnchantmentGUI.reformat((String)enchantment.func_77320_a());
        }
        GUIStringPicker name = new GUIStringPicker((GUIScreen)this, EnchantmentGUI.reformat((String)"setbonus.config.type"), validNames);
        name.set((this.enchantment.func_190936_d() ? TextFormatting.RED : TextFormatting.GREEN) + "" + EnchantmentGUI.reformat((String)this.enchantment.func_77320_a()));
        this.root.add((GUIElement)name);
        this.root.add(new GUIElement((GUIScreen)this, 1.0, 0.0));
        String[] possibleModes = new String[5];
        for (int i2 = 0; i2 < possibleModes.length; ++i2) {
            possibleModes[i2] = EnchantmentGUI.reformat((String)("setbonus.enchantmode." + i2));
        }
        GUIStringPicker modePicker = new GUIStringPicker((GUIScreen)this, EnchantmentGUI.reformat((String)"setbonus.config.mode"), possibleModes);
        modePicker.set(possibleModes[this.mode]);
        this.root.add((GUIElement)modePicker);
        this.root.add(new GUIElement((GUIScreen)this, 1.0, 0.0));
        GUILabeledTextInput levelInput = new GUILabeledTextInput((GUIScreen)this, EnchantmentGUI.reformat((String)"setbonus.config.level") + ": ", "" + this.level, (TextFilter)FilterInt.INSTANCE);
        this.root.add((GUIElement)levelInput);
        this.root.add(new GUIElement((GUIScreen)this, 1.0, 0.0));
        save.addClickActions(new Runnable[]{() -> {
            if (!levelInput.valid()) {
                levelInput.setText("" + this.level);
                levelInput.label.click();
            } else {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValues().get(Tools.indexOf((Object[])validNames, (Object)name.value));
                clickedElement.set(enchantment, Tools.indexOf((Object[])possibleModes, (Object)modePicker.value), FilterInt.INSTANCE.parse(levelInput.getText()));
                this.close();
            }
        }});
    }

    public String title() {
        return EnchantmentGUI.reformat((String)"setbonus.config.attributeModifier");
    }
}

