/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus;

import com.fantasticsource.mctools.ClientTickTimer;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.setbonus.Compat;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.client.SetBonusGUI;
import com.fantasticsource.setbonus.client.TooltipRenderer;
import com.fantasticsource.setbonus.client.gui.SetBonusConfigGUI;
import com.fantasticsource.setbonus.common.Commands;
import com.fantasticsource.setbonus.common.Network;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementPotionEffect;
import com.fantasticsource.setbonus.config.ConfigHandler;
import com.fantasticsource.setbonus.config.SetBonusConfig;
import com.fantasticsource.setbonus.server.ServerBonus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="setbonus", name="Set Bonus", version="1.12.2.040", dependencies="required-after:fantasticlib@[1.12.2.066,)", acceptedMinecraftVersions="[1.12.2]")
public class SetBonus {
    public static final String MODID = "setbonus";
    public static final String NAME = "Set Bonus";
    public static final String VERSION = "1.12.2.040";
    public static final String CONFIG_VERSION = "1.12.2.009";

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        Compat.init();
        Network.init();
        MinecraftForge.EVENT_BUS.register(SetBonus.class);
        MinecraftForge.EVENT_BUS.register(ServerTickTimer.class);
        MinecraftForge.EVENT_BUS.register(BonusElementPotionEffect.class);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register(ClientTickTimer.class);
            MinecraftForge.EVENT_BUS.register(TooltipRenderer.class);
            MinecraftForge.EVENT_BUS.register(SetBonusGUI.class);
            TooltipRenderer.update();
        }
    }

    @Mod.EventHandler
    public static void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Commands());
        SetBonusData.setServerFromConfig();
    }

    @Mod.EventHandler
    public static void serverStop(FMLServerStoppingEvent event) {
        ServerBonus.dropAll();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void saveConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void calcConfigs(ConfigChangedEvent.PostConfigChangedEvent event) {
        SetBonusData.setServerFromConfig();
        TooltipRenderer.update();
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (event.side == Side.SERVER) {
                ServerBonus.updateBonuses((EntityPlayerMP)event.player, false);
            } else {
                EntityPlayer player = event.player;
                if (Minecraft.func_71410_x().field_71439_g == player) {
                    ClientBonus.updateBonuses(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        Network.WRAPPER.sendTo((IMessage)new Network.HPFixPacket(player), player);
        ServerTickTimer.schedule((int)20, () -> Network.WRAPPER.sendTo((IMessage)new Network.HPFixPacket(player), player));
    }

    @SubscribeEvent
    public static void playerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Network.updateConfig(player);
            Network.WRAPPER.sendTo((IMessage)new Network.HPFixPacket(player), player);
            ServerTickTimer.schedule((int)20, () -> Network.WRAPPER.sendTo((IMessage)new Network.HPFixPacket(player), player));
        }
    }

    @SubscribeEvent
    public static void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerBonus.clearMem(event.player);
    }

    @SubscribeEvent
    public static void disconnectFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            SetBonusData.CLIENT_DATA.clear();
            if (SetBonusConfig.clientSettings.dynamicTooltipSearch > 0) {
                Compat.refreshTooltips();
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void gui(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiModList && gui instanceof GuiConfig && MODID.equals(((GuiConfig)gui).modID)) {
            if (SetBonusConfigGUI.dontReplace) {
                SetBonusConfigGUI.dontReplace = false;
            } else {
                event.setCanceled(true);
                new SetBonusConfigGUI((GuiConfig)gui);
            }
        }
    }

    static {
        ConfigHandler.init();
    }
}

