/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.footsteps.DelayedAcoustic;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.acoustics.EventSelectorAcoustics;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.NullAcoustic;
import org.orecruncher.dsurround.registry.acoustics.ProbabilityWeightsAcoustic;
import org.orecruncher.dsurround.registry.acoustics.SimpleAcoustic;
import org.orecruncher.dsurround.registry.acoustics.SimultaneousAcoustic;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.lib.MCHelper;

@SideOnly(value=Side.CLIENT)
public class AcousticRegistry
extends Registry {
    private static final float default_volMin = 0.9f;
    private static final float default_volMax = 1.0f;
    private static final float default_pitchMin = 0.95f;
    private static final float default_pitchMax = 1.05f;
    private static final float DIVIDE = 100.0f;
    private static final Map<Material, String> materialProfiles = new Reference2ObjectOpenHashMap();
    private final Map<String, IAcoustic> acoustics = new Object2ObjectAVLTreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IAcoustic[]> compiled = new Object2ObjectAVLTreeMap(String.CASE_INSENSITIVE_ORDER);
    public static final IAcoustic[] EMPTY;
    public static final IAcoustic[] NOT_EMITTER;
    public static final IAcoustic[] MESSY_GROUND;
    private int hits;
    private int primitives;
    private int material;

    public AcousticRegistry() {
        super("Acoustic Registry");
    }

    @Override
    protected void preInit() {
        this.hits = 0;
        this.primitives = 0;
        this.material = 0;
        this.acoustics.clear();
        this.compiled.clear();
        this.compiled.put("EMPTY", EMPTY);
        this.compiled.put("NOT_EMITTER", NOT_EMITTER);
        this.compiled.put("MESSY_GROUND", MESSY_GROUND);
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        for (Map.Entry<String, JsonElement> entry : cfg.acoustics.entrySet()) {
            String acousticsName = entry.getKey();
            try {
                JsonObject acousticsDefinition = entry.getValue().getAsJsonObject();
                EventSelectorAcoustics selector = new EventSelectorAcoustics(acousticsName);
                this.parseSelector(selector, acousticsDefinition);
                this.addAcoustic(selector);
            }
            catch (Throwable t) {
                String msg = String.format("Unable to parse Json entry [%s]!", acousticsName);
                ModBase.log().error(msg, t);
            }
        }
        for (Map.Entry<String, Object> entry : cfg.primitiveAcoustics.entrySet()) {
            this.compiled.put(entry.getKey(), this.compileAcoustics((String)entry.getValue()));
        }
    }

    @Override
    protected void complete() {
        ModBase.log().info("[%s] %d cache hits during initialization", new Object[]{this.getName(), this.hits});
        ModBase.log().info("[%s] %d primitives by material generated", new Object[]{this.getName(), this.material});
        ModBase.log().info("[%s] %d primitives by sound generated", new Object[]{this.getName(), this.primitives});
    }

    @Nonnull
    public IAcoustic[] resolvePrimitive(@Nonnull IBlockState state) {
        if (state == Blocks.field_150350_a.func_176223_P()) {
            return NOT_EMITTER;
        }
        SoundType type = MCHelper.getSoundType((IBlockState)state);
        String soundName = type != null && type.func_185844_d() != null && !type.func_185844_d().func_187503_a().func_110624_b().isEmpty() ? type.func_185844_d().func_187503_a().toString() : null;
        IAcoustic[] acoustics = null;
        if (soundName == null || soundName.startsWith("minecraft")) {
            acoustics = this.resolveByMaterial(state);
        }
        if (acoustics != null) {
            ++this.material;
        }
        if (acoustics == null && StringUtils.isNotEmpty((CharSequence)soundName)) {
            acoustics = this.getPrimitive(soundName);
        }
        return (IAcoustic[])MoreObjects.firstNonNull((Object)acoustics, (Object)EMPTY);
    }

    @Nonnull
    private IAcoustic[] getPrimitive(@Nonnull String primitive) {
        IAcoustic[] result = this.compiled.get(primitive);
        if (result == null) {
            IAcoustic a = this.generateAcoustic(primitive);
            result = new IAcoustic[]{a};
            this.compiled.put(primitive, result);
            ++this.primitives;
        }
        return result;
    }

    @Nullable
    private IAcoustic[] resolveByMaterial(@Nonnull IBlockState state) {
        IAcoustic[] result = null;
        String profile = materialProfiles.get(state.func_185904_a());
        if (StringUtils.isNotEmpty((CharSequence)profile)) {
            result = this.compileAcoustics(profile);
        }
        return result == EMPTY ? null : result;
    }

    private void addAcoustic(@Nonnull IAcoustic acoustic) {
        this.acoustics.put(acoustic.getName(), acoustic);
    }

    @Nullable
    public IAcoustic getAcoustic(@Nonnull String name) {
        return this.acoustics.get(name);
    }

    @Nonnull
    public IAcoustic[] compileAcoustics(@Nonnull String acousticName) {
        IAcoustic[] result = this.compiled.get(acousticName);
        if (result == null) {
            result = (IAcoustic[])Arrays.stream(acousticName.split(",")).map(this::generateAcoustic).toArray(IAcoustic[]::new);
            if (result.length == 0) {
                result = EMPTY;
            }
            this.compiled.put(acousticName, result);
        } else {
            ++this.hits;
        }
        return result;
    }

    @Nonnull
    private IAcoustic generateAcoustic(@Nonnull String name) {
        IAcoustic a = this.acoustics.get(name);
        if (a == null) {
            ResourceLocation loc = new ResourceLocation(name);
            SoundEvent evt = RegistryManager.SOUND.getSound(loc);
            a = this.generateAcoustic(evt);
        }
        return a;
    }

    @Nonnull
    private IAcoustic generateAcoustic(@Nonnull SoundEvent evt) {
        IAcoustic result = this.acoustics.get(evt.func_187503_a().toString());
        if (result == null) {
            result = new SimpleAcoustic(evt);
            this.acoustics.put(result.getName(), result);
        }
        return result;
    }

    private void parseSelector(EventSelectorAcoustics selector, JsonObject acousticsDefinition) {
        for (EventType i : EventType.values()) {
            String eventName = i.jsonName();
            if (!acousticsDefinition.has(eventName)) continue;
            JsonElement unsolved = acousticsDefinition.get(eventName);
            IAcoustic acoustic = this.solveAcoustic(unsolved);
            selector.setAcousticPair(i, acoustic);
        }
    }

    private IAcoustic solveAcoustic(JsonElement unsolved) {
        IAcoustic ret = null;
        if (unsolved.isJsonObject()) {
            ret = this.solveAcousticsCompound(unsolved.getAsJsonObject());
        } else if (unsolved.isJsonPrimitive() && unsolved.getAsJsonPrimitive().isString()) {
            SimpleAcoustic a = new SimpleAcoustic();
            this.prepareDefaults(a);
            this.setupSoundName(a, unsolved.getAsString());
            ret = a;
        }
        if (ret == null) {
            throw new IllegalStateException("Unresolved Json element: \r\n" + unsolved.toString());
        }
        return ret;
    }

    private IAcoustic solveAcousticsCompound(JsonObject unsolved) {
        IAcoustic ret = null;
        if (!unsolved.has("type") || unsolved.get("type").getAsString().equals("basic")) {
            SimpleAcoustic a = new SimpleAcoustic();
            this.prepareDefaults(a);
            this.setupClassics(a, unsolved);
            ret = a;
        } else {
            String type;
            switch (type = unsolved.get("type").getAsString()) {
                case "simultaneous": {
                    ArrayList<IAcoustic> acoustics = new ArrayList<IAcoustic>();
                    JsonArray sim = unsolved.getAsJsonArray("array");
                    for (JsonElement subElement : sim) {
                        acoustics.add(this.solveAcoustic(subElement));
                    }
                    ret = new SimultaneousAcoustic(acoustics);
                    break;
                }
                case "delayed": {
                    DelayedAcoustic a = new DelayedAcoustic();
                    this.prepareDefaults(a);
                    this.setupClassics(a, unsolved);
                    if (unsolved.has("delay")) {
                        a.setDelayMin(unsolved.get("delay").getAsInt());
                        a.setDelayMax(unsolved.get("delay").getAsInt());
                    } else {
                        a.setDelayMin(unsolved.get("delay_min").getAsInt());
                        a.setDelayMax(unsolved.get("delay_max").getAsInt());
                    }
                    ret = a;
                    break;
                }
                case "probability": {
                    ArrayList<Integer> weights = new ArrayList<Integer>();
                    ArrayList<IAcoustic> acoustics = new ArrayList<IAcoustic>();
                    JsonArray sim = unsolved.getAsJsonArray("array");
                    Iterator iter = sim.iterator();
                    while (iter.hasNext()) {
                        JsonElement subElement = (JsonElement)iter.next();
                        weights.add(subElement.getAsInt());
                        if (!iter.hasNext()) {
                            throw new IllegalStateException("Probability has odd number of children!");
                        }
                        subElement = (JsonElement)iter.next();
                        acoustics.add(this.solveAcoustic(subElement));
                    }
                    ret = new ProbabilityWeightsAcoustic(acoustics, weights);
                    break;
                }
            }
        }
        return ret;
    }

    private void prepareDefaults(@Nonnull SimpleAcoustic a) {
        a.setVolMin(0.9f);
        a.setVolMax(1.0f);
        a.setPitchMin(0.95f);
        a.setPitchMax(1.05f);
    }

    private void setupSoundName(@Nonnull SimpleAcoustic a, @Nonnull String soundName) {
        try {
            ResourceLocation res = "@".equals(soundName) ? null : (soundName.contains(":") ? new ResourceLocation(soundName) : (soundName.charAt(0) != '@' ? new ResourceLocation("dsurround", soundName) : new ResourceLocation("minecraft", soundName.substring(1))));
            if (res == null) {
                a.setSound(null);
            } else {
                a.setSound(RegistryManager.SOUND.getSound(res));
            }
        }
        catch (Throwable t) {
            ModBase.log().warn("Unable to locate sound [%s]", new Object[]{soundName});
            a.setSound(null);
        }
    }

    private void setupClassics(SimpleAcoustic a, JsonObject solved) {
        this.setupSoundName(a, solved.get("name").getAsString());
        if (solved.has("vol_min")) {
            a.setVolMin(this.processPitchOrVolume(solved, "vol_min"));
        }
        if (solved.has("vol_max")) {
            a.setVolMax(this.processPitchOrVolume(solved, "vol_max"));
        }
        if (solved.has("pitch_min")) {
            a.setPitchMin(this.processPitchOrVolume(solved, "pitch_min"));
        }
        if (solved.has("pitch_max")) {
            a.setPitchMax(this.processPitchOrVolume(solved, "pitch_max"));
        }
    }

    private float processPitchOrVolume(@Nonnull JsonObject object, @Nonnull String param) {
        return object.get(param).getAsFloat() / 100.0f;
    }

    static {
        materialProfiles.put(Material.field_151579_a, "NOT_EMITTER");
        materialProfiles.put(Material.field_151577_b, "grass");
        materialProfiles.put(Material.field_151578_c, "dirt");
        materialProfiles.put(Material.field_151575_d, "wood");
        materialProfiles.put(Material.field_151576_e, "stone");
        materialProfiles.put(Material.field_151573_f, "hardmetal");
        materialProfiles.put(Material.field_151574_g, "metalcompressed,hardmetal");
        materialProfiles.put(Material.field_151586_h, "NOT_EMITTER");
        materialProfiles.put(Material.field_151587_i, "NOT_EMITTER");
        materialProfiles.put(Material.field_151584_j, "leaves");
        materialProfiles.put(Material.field_151585_k, "brush");
        materialProfiles.put(Material.field_151582_l, "leaves");
        materialProfiles.put(Material.field_151583_m, "organic_dry");
        materialProfiles.put(Material.field_151580_n, "rug");
        materialProfiles.put(Material.field_151581_o, "NOT_EMITTER");
        materialProfiles.put(Material.field_151595_p, "sand");
        materialProfiles.put(Material.field_151594_q, "stoneutility");
        materialProfiles.put(Material.field_151593_r, "rug");
        materialProfiles.put(Material.field_151592_s, "glass");
        materialProfiles.put(Material.field_151591_t, "NOT_EMITTER");
        materialProfiles.put(Material.field_151590_u, "equipment");
        materialProfiles.put(Material.field_151589_v, "NOT_EMITTER");
        materialProfiles.put(Material.field_151588_w, "ice");
        materialProfiles.put(Material.field_151598_x, "ice");
        materialProfiles.put(Material.field_151597_y, "snow");
        materialProfiles.put(Material.field_151596_z, "snow");
        materialProfiles.put(Material.field_151570_A, "grass");
        materialProfiles.put(Material.field_151571_B, "dirt");
        materialProfiles.put(Material.field_151572_C, "organic_dry");
        materialProfiles.put(Material.field_151566_D, "obsidian");
        materialProfiles.put(Material.field_151567_E, "NOT_EMITTER");
        materialProfiles.put(Material.field_151568_F, "organic");
        materialProfiles.put(Material.field_151569_G, "NOT_EMITTER");
        materialProfiles.put(Material.field_76233_E, "stonemachine");
        materialProfiles.put(Material.field_175972_I, "glass");
        materialProfiles.put(Material.field_189963_J, "NOT_EMITTER");
        EMPTY = new IAcoustic[0];
        NOT_EMITTER = new IAcoustic[]{new NullAcoustic("NOT_EMITTER")};
        MESSY_GROUND = new IAcoustic[]{new NullAcoustic("MESSY_GROUND")};
    }
}

