/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.sound.Emitter;
import org.orecruncher.dsurround.client.sound.EntityEmitter;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.client.sound.SoundState;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.registry.RegistryDataEvent;
import org.orecruncher.dsurround.registry.sound.SoundRegistry;
import org.orecruncher.lib.ReflectedField;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class SoundEffectHandler
extends EffectHandlerBase {
    private static final ReflectedField.IntegerField<Object> ambienceTicks = new ReflectedField.IntegerField("net.minecraft.client.multiplayer.WorldClient", "ambienceTicks", "field_184158_M");
    public static final SoundEffectHandler INSTANCE = new SoundEffectHandler();
    private final Object2ObjectOpenHashMap<SoundEffect, Emitter> emitters = new Object2ObjectOpenHashMap();
    private final ObjectArray<PendingSound> pending = new ObjectArray();

    private SoundEffectHandler() {
        super("Sound Effects");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.emitters.values().forEach(Emitter::update);
        this.pending.stream().filter(s -> s.getTickAge() >= 0).forEach(s -> INSTANCE.playSound(s.getSound()));
        this.pending.removeIf(s -> s.getTickAge() >= 0);
        this.doMoodProcessing();
    }

    @Override
    public void onConnect() {
        this.clearSounds();
    }

    @Override
    public void onDisconnect() {
        this.clearSounds();
    }

    public void clearSounds() {
        this.emitters.values().forEach(Emitter::stop);
        this.emitters.clear();
        this.pending.clear();
        SoundEngine.instance().stopAllSounds();
    }

    public void queueAmbientSounds(@Nonnull Object2FloatOpenHashMap<SoundEffect> sounds) {
        this.emitters.object2ObjectEntrySet().removeIf(entry -> {
            Emitter emitter = (Emitter)entry.getValue();
            if (emitter.isDonePlaying()) {
                return true;
            }
            float volume = sounds.getFloat(entry.getKey());
            if (volume > 0.0f) {
                emitter.setVolumeThrottle(volume);
                if (emitter.isFading()) {
                    emitter.unfade();
                }
                sounds.removeFloat(entry.getKey());
            } else if (!emitter.isFading()) {
                emitter.fade();
            }
            return false;
        });
        sounds.forEach((fx, volume) -> {
            EntityEmitter e = new EntityEmitter((EntityLivingBase)EnvironStateHandler.EnvironState.getPlayer(), (SoundEffect)fx);
            e.setVolumeThrottle(volume.floatValue());
            this.emitters.put(fx, (Object)e);
        });
    }

    public void stopSound(@Nonnull ISoundInstance sound2) {
        SoundEngine.instance().stopSound(sound2);
    }

    public boolean playSound(@Nonnull ISoundInstance sound2) {
        return sound2.canSoundBeHeard() && SoundEngine.instance().playSound(sound2);
    }

    public void playSoundAtPlayer(@Nonnull EntityPlayer player2, @Nonnull SoundEffect sound2) {
        this.playSound(sound2.createSoundNear((Entity)player2));
    }

    public boolean playSoundAt(@Nonnull BlockPos pos, @Nonnull SoundEffect sound2, int tickDelay) {
        SoundInstance s = sound2.createSoundAt(pos);
        if (tickDelay == 0) {
            return this.playSound(s);
        }
        s.setState(SoundState.DELAYED);
        this.pending.add((Object)new PendingSound(s, tickDelay));
        return false;
    }

    @SubscribeEvent
    public void registryReloadEvent(@Nonnull RegistryDataEvent.Reload event) {
        if (event.reg instanceof SoundRegistry) {
            this.onConnect();
        }
    }

    @SubscribeEvent
    public void playerJoinWorldEvent(@Nonnull EntityJoinWorldEvent event) {
        if (SoundEffectHandler.getPlayer() != null && event.getEntity().func_130014_f_().field_72995_K && EnvironStateHandler.EnvironState.isPlayer(event.getEntity()) && !event.getEntity().field_70128_L) {
            this.clearSounds();
        }
    }

    public void doMoodProcessing() {
        BlockPos blockpos;
        IBlockState iblockstate;
        int deltaZ;
        int deltaY;
        int deltaX;
        int distance;
        if (!(EnvironStateHandler.EnvironState.getWorld() instanceof WorldClient)) {
            return;
        }
        WorldClient wc = (WorldClient)EnvironStateHandler.EnvironState.getWorld();
        int ticks = ambienceTicks.get((Object)wc);
        if (ticks == 1 && (distance = (deltaX = this.RANDOM.nextInt(30) - 15) * deltaX + (deltaY = this.RANDOM.nextInt(30) - 15) * deltaY + (deltaZ = this.RANDOM.nextInt(30) - 15) * deltaZ) > 4 && distance <= 255 && (iblockstate = wc.func_180495_p(blockpos = EnvironStateHandler.EnvironState.getPlayerPosition().func_177982_a(deltaX, deltaY, deltaZ))).func_185904_a() == Material.field_151579_a && wc.func_175642_b(EnumSkyBlock.SKY, blockpos) <= 0 && wc.func_175699_k(blockpos) <= this.RANDOM.nextInt(8)) {
            SoundInstance fx = Sounds.AMBIENT_CAVE.createSoundAt(blockpos).setVolume(0.9f).setPitch(0.8f + this.RANDOM.nextFloat() * 0.2f);
            this.playSound(fx);
            ticks = this.RANDOM.nextInt(12000) + 6000;
            ModBase.log().debug("Next ambient event: %d ticks", new Object[]{ticks});
        }
        if (ticks == 1) {
            ticks = 2;
        }
        ambienceTicks.set((Object)wc, ticks);
    }

    @SubscribeEvent
    public void diagnostics(@Nonnull DiagnosticEvent.Gather event) {
        if (EnvironStateHandler.EnvironState.getWorld() instanceof WorldClient) {
            event.output.add(String.format("Ambiance Timer: %d", ambienceTicks.get((Object)EnvironStateHandler.EnvironState.getWorld())));
        }
        this.emitters.values().forEach(emitter -> event.output.add("EMITTER: " + emitter.toString()));
        this.pending.forEach(effect -> event.output.add((effect.getTickAge() < 0 ? "DELAYED: " : "PENDING: ") + effect.getSound().toString()));
    }

    private static final class PendingSound {
        private final int timeMark;
        private final ISoundInstance sound;

        public PendingSound(@Nonnull ISoundInstance sound2, int delay) {
            this.timeMark = EnvironStateHandler.EnvironState.getTickCounter() + delay;
            this.sound = sound2;
        }

        public int getTickAge() {
            return EnvironStateHandler.EnvironState.getTickCounter() - this.timeMark;
        }

        @Nonnull
        public ISoundInstance getSound() {
            return this.sound;
        }
    }
}

