/*
 * Decompiled with CFR 0.152.
 */
package luckified.util;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import luckified.Luckified;

public class EarlyConfigReader {
    private static File configFile = null;
    private static String configBooleanString = null;
    private static String configIntString = null;
    private static String configDoubleString = null;
    private static Map<String, Boolean> configArrayFilledMap = null;

    public static boolean getBoolean(String name, boolean defaultValue) {
        if (configFile == null) {
            configFile = new File("config", "luckified.cfg");
        }
        if (configBooleanString == null) {
            if (configFile.exists() && configFile.isFile()) {
                try (Stream<String> stream = Files.lines(configFile.toPath());){
                    configBooleanString = stream.filter(s -> s.trim().startsWith("B:")).collect(Collectors.joining());
                }
                catch (Exception e) {
                    Luckified.LOGGER.error("Failed to parse RLCraft Luckified config: " + e);
                }
            } else {
                configBooleanString = "";
            }
        }
        if (configBooleanString.contains("B:\"" + name + "\"=")) {
            return configBooleanString.contains("B:\"" + name + "\"=true");
        }
        return defaultValue;
    }

    public static int getInt(String name, int defaultValue) {
        if (configFile == null) {
            configFile = new File("config", "luckified.cfg");
        }
        if (configIntString == null) {
            if (configFile.exists() && configFile.isFile()) {
                try (Stream<String> stream = Files.lines(configFile.toPath());){
                    configIntString = stream.filter(s -> s.trim().startsWith("I:")).collect(Collectors.joining());
                }
                catch (Exception ex) {
                    Luckified.LOGGER.error("Failed to parse RLCraft Luckified config: " + ex);
                }
            } else {
                configIntString = "";
            }
        }
        if (configIntString.contains("I:\"" + name + "\"=")) {
            int index = configIntString.indexOf("I:\"" + name + "\"=");
            try {
                Matcher matcher = Pattern.compile("(\\d+)").matcher(configIntString.substring(index));
                matcher.find();
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                Luckified.LOGGER.error("RLCraft Luckified: Failed to parse int config " + name + ", " + e);
                return 0;
            }
        }
        return defaultValue;
    }

    public static double getDouble(String name, double defaultValue) {
        if (configFile == null) {
            configFile = new File("config", "luckified.cfg");
        }
        if (configDoubleString == null) {
            if (configFile.exists() && configFile.isFile()) {
                try (Stream<String> stream = Files.lines(configFile.toPath());){
                    configDoubleString = stream.filter(s -> s.trim().startsWith("D:")).collect(Collectors.joining());
                }
                catch (Exception ex) {
                    Luckified.LOGGER.error("Failed to parse RLCraft Luckified config: " + ex);
                }
            } else {
                configDoubleString = "";
            }
        }
        if (configDoubleString.contains("D:\"" + name + "\"=")) {
            int index = configDoubleString.indexOf("D:\"" + name + "\"=");
            try {
                Matcher matcher = Pattern.compile("(\\d+(\\.\\d*)?([eE][+\\-]?\\d+)?(dDfF)?)").matcher(configDoubleString.substring(index));
                matcher.find();
                return Double.parseDouble(matcher.group(1));
            }
            catch (Exception e) {
                Luckified.LOGGER.error("RLCraft Luckified: Failed to parse double config " + name + ", " + e);
                return 0.0;
            }
        }
        return defaultValue;
    }

    public static boolean isArrayFilled(String name, boolean filledByDefault) {
        if (configFile == null) {
            configFile = new File("config", "luckified.cfg");
        }
        if (configArrayFilledMap == null) {
            configArrayFilledMap = new HashMap<String, Boolean>();
            if (configFile.exists() && configFile.isFile()) {
                try {
                    String allLines = Files.lines(configFile.toPath()).collect(Collectors.joining("\t"));
                    Matcher matcher = Pattern.compile("[SID]:\"([^\t]+)\" <([^>]*)>").matcher(allLines);
                    while (matcher.find()) {
                        configArrayFilledMap.put(matcher.group(1), !matcher.group(2).matches("\\s*"));
                    }
                }
                catch (Exception ex) {
                    Luckified.LOGGER.error("Failed to parse RLCraft Luckified config: " + ex);
                }
            }
        }
        return configArrayFilledMap.getOrDefault(name, filledByDefault);
    }
}

