/*
 * Decompiled with CFR 0.152.
 */
package luckified.mixin.modded;

import luckified.ModConfig;
import lykrast.defiledlands.common.entity.passive.EntityBookWyrm;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityBookWyrm.class})
public abstract class EntityBookWyrmMixin {
    @Unique
    private EntityPlayer luckified$lastInteractingPlayer = null;

    @Shadow(remap=false)
    public abstract boolean isGolden();

    @Inject(method={"processInteract"}, at={@At(value="HEAD")})
    public void luckified_saveLastInteractingPlayer(EntityPlayer player, EnumHand hand, CallbackInfoReturnable<Boolean> cir) {
        this.luckified$lastInteractingPlayer = player;
    }

    @Inject(method={"setOffspringAttributes"}, at={@At(value="INVOKE", target="Llykrast/defiledlands/common/entity/passive/EntityBookWyrm;getDigestTime()I", ordinal=0)}, remap=false)
    public void luckified_increaseGoldChance(EntityBookWyrm parent, EntityBookWyrm child, CallbackInfo ci) {
        if (this.luckified$lastInteractingPlayer == null) {
            return;
        }
        float luck = this.luckified$lastInteractingPlayer.func_184817_da();
        if (luck <= 0.0f) {
            return;
        }
        boolean isGold = child.func_70681_au().nextFloat() < this.luckified$getChildGoldChance(parent, luck);
        child.setGolden(isGold);
        this.luckified$lastInteractingPlayer = null;
    }

    @Unique
    private float luckified$getChildGoldChance(EntityBookWyrm parent, float luck) {
        boolean thisIsGold = this.isGolden();
        boolean parentIsGold = parent.isGolden();
        float childGoldChance = 0.04f;
        if (!thisIsGold && !parentIsGold) {
            childGoldChance = 0.01f;
        }
        if (thisIsGold && parentIsGold) {
            childGoldChance = 0.1f;
        }
        return childGoldChance *= 1.0f + luck * ModConfig.defiledlands.goldWyrmPerLuck;
    }
}

