/*
 * Decompiled with CFR 0.152.
 */
package luckified;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="luckified")
public class ModConfig {
    @Config.Comment(value={"Infernal Mobs Options"})
    @Config.Name(value="Infernal Mobs")
    public static final InfernalMobsConfig infernalmobs = new InfernalMobsConfig();
    @Config.Comment(value={"RLArtifacts Options"})
    @Config.Name(value="RLArtifacts")
    public static final RLArtifactsConfig rlArtifacts = new RLArtifactsConfig();
    @Config.Comment(value={"Bountiful Baubles Options"})
    @Config.Name(value="Bountiful Baubles")
    public static final BountifulBaublesConfig bountifulBaubles = new BountifulBaublesConfig();
    @Config.Comment(value={"Quality Tools Options"})
    @Config.Name(value="Quality Tools")
    public static final QualityToolsConfig qualityTools = new QualityToolsConfig();
    @Config.Comment(value={"Vanilla Options"})
    @Config.Name(value="Minecraft")
    public static final VanillaConfig vanilla = new VanillaConfig();
    @Config.Comment(value={"Defiled Lands Options"})
    @Config.Name(value="Defiled Lands")
    public static DefiledLandsConfig defiledlands = new DefiledLandsConfig();
    @Config.Comment(value={"SME Options"})
    @Config.Name(value="So Many Enchantments")
    public static SoManyEnchantmentsConfig somanyenchantments = new SoManyEnchantmentsConfig();

    @Mod.EventBusSubscriber(modid="luckified")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("luckified")) {
                ConfigManager.sync((String)"luckified", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class SoManyEnchantmentsConfig {
        @Config.Comment(value={"Increases Enchanting Lvl with the Luck POTION EFFECT (not attribute) by this amount per lvl of the effect. Disable with 0"})
        @Config.Name(value="SME: Enchant Focus Modifier per Luck")
        @Config.RangeDouble(min=0.0)
        public float luckEnchantingPowerModifier = 1.0f;
        @Config.Comment(value={"Which operation to use for the SME enchant focus attribute modifier on luck potion"})
        @Config.Name(value="SME: Enchant Focus Operation")
        @Config.RangeInt(min=0, max=2)
        public int luckEnchantingPowerOperation = 0;
    }

    public static class DefiledLandsConfig {
        @Config.Comment(value={"Each point of luck will multiplicatively increase default chance to breed golden bookwyrm by this factor in percent. So with 5 Luck and Factor of 0.2, all default chances are increased by +100%, so multiplied by 2 (meaning 1% turns to 2%). Default: 0.2. Disable with 0.0"})
        @Config.Name(value="DefiledLands: Increased Gold Bookwyrm chance per Luck")
        @Config.RangeDouble(min=0.0)
        public float goldWyrmPerLuck = 0.2f;
    }

    @MixinConfig(name="luckified")
    public static class VanillaConfig {
        @Config.Comment(value={"How many enchanting levels added per luck attribute to enchanted player generated loot, generating a GREEN item (default: 1.0). Disable with 0.0"})
        @Config.Name(value="Lucky Loot: Added enchantability per luck")
        @Config.RangeDouble(min=0.0)
        public float luckEnchantabilityLoot = 1.0f;
        @Config.Comment(value={"Base chance to roll lucky loot, generating a GREEN item (default: 0.5). Disable with 0.0"})
        @Config.Name(value="Lucky Loot: Base chance")
        @Config.RangeDouble(min=0.0)
        public float luckyLootBaseChance = 0.5f;
        @Config.Comment(value={"Chance per luck to roll lucky loot, generating a GREEN item (default: 0.05). Disable with 0.0"})
        @Config.Name(value="Lucky Loot: Chance per luck")
        @Config.RangeDouble(min=0.0)
        public float luckyLootPerLuck = 0.05f;
        @Config.Comment(value={"Change colors of items that have rolled max enchantability or have generated with luck"})
        @Config.Name(value="Loot: Changed Item Colors")
        @Config.RequiresMcRestart
        @MixinConfig.MixinToggle(earlyMixin="mixins.luckified.vanilla.coloreditems.json", defaultValue=true)
        @MixinConfig.CompatHandling(modid="noexpensive", desired=false, reason="Option not fully compatible with NoExpensive, disable the config or remove NoExpensive. Otherwise items with colored names will behave weirdly in anvils.")
        public boolean changeItemColors = true;
        @Config.Comment(value={"If loot rolls the extra chance for max enchantability (YELLOW or GOLD), it will get this many levels added flat (default: 10). Disable with 0"})
        @Config.Name(value="Max roll Loot: Added Enchantability flat")
        @Config.RangeInt(min=0)
        public int addedEnchantabilityForMaxRollLoot = 10;
        @Config.Comment(value={"If loot rolls the extra chance for max enchantability (YELLOW or GOLD), it will get this many levels added per luck (default: 2.0). Disable with 0.0"})
        @Config.Name(value="Max roll Loot: Added enchantability per luck")
        @Config.RangeDouble(min=0.0)
        public float luckEnchantabilityMaxLoot = 2.0f;
        @Config.Comment(value={"Base chance to roll max possible level for loot enchantability, generating a YELLOW or GOLD item (default: 0.05). Disable with 0.0"})
        @Config.Name(value="Max roll Loot: Base chance")
        @Config.RangeDouble(min=0.0)
        public float maxEnchantabilityLootBaseChance = 0.05f;
        @Config.Comment(value={"Chance per Luck to roll max possible level for loot enchantability, generating a GOLD item (default: 0.02). Disable with 0.0"})
        @Config.Name(value="Max roll Loot: Chance per luck")
        @Config.RangeDouble(min=0.0)
        public float maxEnchantabilityLootPerLuck = 0.02f;
        @Config.Comment(value={"Increase weights for higher lvls of enchants on trades with librarians by this factor per luck (default: 0.1). Disable with 0.0"})
        @Config.Name(value="Librarian: Weight factor for higher enchant levels per luck")
        @Config.RangeDouble(min=0.0)
        public float librarianEnchLevelWeightFactor = 0.1f;
    }

    public static class QualityToolsConfig {
        @Config.Comment(value={"Increase weights for rare qualities by this much per luck attribute (default: 1.0). Disable with 0.0"})
        @Config.Name(value="QualityTools: Luck increased weights for rare Qualities")
        @Config.RangeDouble(min=0.0)
        public float rareQualityWeightPerLuck = 1.0f;
        @Config.Comment(value={"Denote the quality names which RLLuck will read as \"rare\" and increase with luck. Clear this list to fully disable this feature."})
        @Config.Name(value="QualityTools: Rare qualities")
        @Config.RequiresMcRestart
        public String[] rareQualityList = new String[]{"quality.masterful.name", "quality.legendary.name", "quality.undying.name", "quality.punishing.name", "quality.arcane.name", "quality.mystical.name"};
    }

    public static class BountifulBaublesConfig {
        @Config.Comment(value={"Increase weights for rare modifiers by this much per luck attribute (default: 0.2). Disable with 0.0"})
        @Config.Name(value="BountifulBaubles: Luck increased weights for rare modifiers")
        @Config.RangeDouble(min=0.0)
        public float rareModifierWeightPerLuck = 0.2f;
        @Config.Comment(value={"Denote the modifier names which RLLuck will read as \"rare\" and increase with luck. Clear this list to fully disable this feature."})
        @Config.Name(value="BountifulBaubles: Rare modifiers")
        @Config.RequiresMcRestart
        public String[] rareModifierList = new String[]{"armored", "hearty", "violent", "menacing", "quick"};
    }

    public static class RLArtifactsConfig {
        @Config.Comment(value={"Increase mimic spawn chance by this much per luck attribute (default: 0.001=0.1%). Disable with 0.0"})
        @Config.Name(value="RLArtifacts: Luck increased mimic spawn chance")
        @Config.RangeDouble(min=0.0)
        public float luckMimicChance = 0.001f;
    }

    @MixinConfig(name="luckified")
    public static class InfernalMobsConfig {
        @Config.Comment(value={"Fix InfernalMobs mistakingly using material enchantability for the enchantability lvl"})
        @Config.Name(value="InfernalMobs Fix Loot Enchantability")
        @Config.RequiresMcRestart
        @MixinConfig.MixinToggle(lateMixin="mixins.luckified.infernalmobs.json", defaultValue=true)
        @MixinConfig.CompatHandling(modid="infernalmobs", desired=true, warnIngame=false, reason="Luckified compat for InfernalMobs, disabled since InfernalMobs not present.")
        public boolean fixInfernalMobsEnchantability = true;
        @Config.Comment(value={"Enchantability range of Items dropped by rare (blue) InfernalMobs"})
        @Config.Name(value="InfernalMobs Rare Enchantability")
        @Config.RangeInt(min=0)
        public int[] infernalMobsEnchantabilityElite = new int[]{10, 20};
        @Config.Comment(value={"Enchantability range of Items dropped by ultra (yellow) InfernalMobs"})
        @Config.Name(value="InfernalMobs Ultra Enchantability")
        @Config.RangeInt(min=0)
        public int[] infernalMobsEnchantabilityUltra = new int[]{20, 30};
        @Config.Comment(value={"Enchantability range of Items dropped by infernal (gold) InfernalMobs"})
        @Config.Name(value="InfernalMobs Infernal Enchantability")
        @Config.RangeInt(min=0)
        public int[] infernalMobsEnchantabilityInfernal = new int[]{30, 50};
    }
}

