/*
 * Decompiled with CFR 0.152.
 */
package luckified;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import luckified.ModConfig;
import luckified.util.SMECompatUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="luckified", version="1.1.2", name="RLCraft Luckified", dependencies="required-after:fermiumbooter@[1.3.2,)", acceptableRemoteVersions="*")
public class Luckified {
    public static final String MODID = "luckified";
    public static final String VERSION = "1.1.2";
    public static final String NAME = "RLCraft Luckified";
    public static final Logger LOGGER = LogManager.getLogger();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"somanyenchantments") && ModConfig.somanyenchantments.luckEnchantingPowerModifier > 0.0f && Luckified.modIsAboveOrEqualVersion("somanyenchantments", "1.0.0")) {
            SMECompatUtil.registerEnchantFocusModifier();
        }
    }

    private static boolean modIsAboveOrEqualVersion(String modid, String compareVersion) {
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (modContainer == null) {
            LOGGER.warn("Luckified: Mod versioning can't be compared for mod {}, mod isn't loaded", (Object)modid);
            return false;
        }
        String modVersion = modContainer.getVersion();
        if (modVersion.equals(compareVersion)) {
            return true;
        }
        if (!modVersion.matches("\\d+(\\.\\d+)*")) {
            LOGGER.warn("Luckified: Mod versioning can't be compared for mod {}, version {}", (Object)modid, (Object)modVersion);
            return false;
        }
        List splitActual = Arrays.stream(modVersion.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
        List splitCompare = Arrays.stream(compareVersion.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
        for (int i = 0; i < splitActual.size(); ++i) {
            int compVersion;
            if (i >= splitCompare.size()) {
                return true;
            }
            int actualVersion = (Integer)splitActual.get(i);
            if (actualVersion > (compVersion = ((Integer)splitCompare.get(i)).intValue())) {
                return true;
            }
            if (actualVersion >= compVersion) continue;
            return false;
        }
        return splitActual.size() >= splitCompare.size();
    }
}

