/*
 * Decompiled with CFR 0.152.
 */
package minenash.monsters_in_the_closet.mixin;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Entity {
    public ServerPlayerMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"startSleepInBed"}, at={@At(value="RETURN")})
    public void highlightMobs(BlockPos pos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> info) {
        Optional reason = ((Either)info.getReturnValue()).left();
        if (this.level() != null && reason.isPresent() && reason.get() == Player.BedSleepingProblem.NOT_SAFE) {
            Vec3 vec3d = Vec3.atBottomCenterOf((Vec3i)pos);
            List list = this.level().getEntitiesOfClass(Monster.class, new AABB(vec3d.x - 8.0, vec3d.y - 5.0, vec3d.z - 8.0, vec3d.x + 8.0, vec3d.y + 5.0, vec3d.z + 8.0), hostileEntity -> hostileEntity.isPreventingPlayerRest((Player)this));
            for (Monster entity : list) {
                entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60, 0, true, false));
            }
        }
    }
}

