/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.world.random.lcg;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2487;

public class Lcg {
    public static final Lcg JAVA = new Lcg(25214903917L, 11L, 0x1000000000000L);
    public final long multiplier;
    public final long addend;
    public final long modulus;
    private final boolean isPowerOf2;
    private final int trailingZeros;

    public Lcg(long multiplier, long addend) {
        this(multiplier, addend, 0L);
    }

    public Lcg(long multiplier, long addend, long modulus) {
        this.multiplier = multiplier;
        this.addend = addend;
        this.modulus = modulus;
        this.isPowerOf2 = (this.modulus & -modulus) == modulus;
        this.trailingZeros = this.isPowerOf2 ? Long.numberOfTrailingZeros(this.modulus) : -1;
    }

    public static Lcg combine(Lcg ... lcgs) {
        Lcg lcg = lcgs[0];
        for (int i = 1; i < lcgs.length; ++i) {
            lcg = lcg.combine(lcgs[i]);
        }
        return lcg;
    }

    public boolean isModPowerOf2() {
        return this.isPowerOf2;
    }

    public int getModTrailingZeroes() {
        return this.trailingZeros;
    }

    public boolean isMultiplicative() {
        return this.addend == 0L;
    }

    public long nextSeed(long seed) {
        return this.mod(seed * this.multiplier + this.addend);
    }

    public long mod(long n) {
        if (this.isModPowerOf2()) {
            return n & this.modulus - 1L;
        }
        if (n <= 0x100000000L) {
            return Long.remainderUnsigned(n, this.modulus);
        }
        throw new UnsupportedOperationException();
    }

    public Lcg combine(long steps) {
        long multiplier = 1L;
        long addend = 0L;
        long intermediateMultiplier = this.multiplier;
        long intermediateAddend = this.addend;
        for (long k = steps; k != 0L; k >>>= 1) {
            if ((k & 1L) != 0L) {
                multiplier *= intermediateMultiplier;
                addend = intermediateMultiplier * addend + intermediateAddend;
            }
            intermediateAddend = (intermediateMultiplier + 1L) * intermediateAddend;
            intermediateMultiplier *= intermediateMultiplier;
        }
        multiplier = this.mod(multiplier);
        addend = this.mod(addend);
        return new Lcg(multiplier, addend, this.modulus);
    }

    public Lcg combine(Lcg lcg) {
        if (this.modulus != lcg.modulus) {
            throw new UnsupportedOperationException();
        }
        return new Lcg(this.multiplier * lcg.multiplier, lcg.multiplier * this.addend + lcg.addend, this.modulus);
    }

    public Lcg invert() {
        return this.combine(-1L);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Lcg)) {
            return false;
        }
        Lcg lcg = (Lcg)other;
        return this.multiplier == lcg.multiplier && this.addend == lcg.addend && this.modulus == lcg.modulus;
    }

    public int hashCode() {
        return Objects.hash(this.multiplier, this.addend, this.modulus);
    }

    public String toString() {
        return "LCG{multiplier=" + this.multiplier + ", addend=" + this.addend + ", modulus=" + this.modulus + "}";
    }

    public static class Adapter
    implements ISimpleAdapter<Lcg, class_2487, JsonObject> {
        private boolean nullable;

        public Adapter(boolean nullable) {
            this.nullable = nullable;
        }

        public Adapter asNullable() {
            return new Adapter(true);
        }

        @Override
        public void writeBits(Lcg lcg, BitBuffer buffer) {
            if (this.nullable) {
                buffer.writeBoolean(lcg == null);
            }
            if (lcg != null) {
                Adapters.LONG.writeBits(lcg.multiplier, buffer);
                Adapters.LONG_SEGMENTED_15.writeBits(lcg.addend, buffer);
                Adapters.LONG.writeBits(lcg.modulus, buffer);
            }
        }

        @Override
        public Optional<Lcg> readBits(BitBuffer buffer) {
            if (this.nullable && buffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(new Lcg((Long)Adapters.LONG.readBits(buffer).orElseThrow(), (Long)Adapters.LONG_SEGMENTED_15.readBits(buffer).orElseThrow(), (Long)Adapters.LONG.readBits(buffer).orElseThrow()));
        }
    }
}

