/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.world.data;

import bigchadguys.sellingbin.SellingBinInventory;
import bigchadguys.sellingbin.block.BinMaterial;
import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.serializable.ISerializable;
import bigchadguys.sellingbin.init.ModConfigs;
import bigchadguys.sellingbin.init.ModNetwork;
import bigchadguys.sellingbin.init.ModWorldData;
import bigchadguys.sellingbin.net.SellingBinEntriesS2CPacket;
import bigchadguys.sellingbin.net.SellingBinTradesS2CPacket;
import bigchadguys.sellingbin.trade.Trade;
import bigchadguys.sellingbin.world.data.WorldData;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SellingBinData
extends WorldData {
    public static List<Trade> CLIENT_TRADES;
    public static Map<String, Integer> CLIENT_TIME_LEFT;
    private List<Trade> lastTrades;
    private final Map<UUID, Map<String, Entry>> entries = new HashMap<UUID, Map<String, Entry>>();

    public Entry getOrCreate(class_1657 player, BinMaterial material) {
        return this.entries.computeIfAbsent(player.method_5667(), unused -> new HashMap()).computeIfAbsent(material.getId(), unused -> new Entry());
    }

    public void onTick(MinecraftServer server) {
        if (this.lastTrades == null) {
            this.lastTrades = ModConfigs.SELLING_BIN.getTrades();
        }
        if (this.lastTrades != ModConfigs.SELLING_BIN.getTrades()) {
            this.lastTrades = ModConfigs.SELLING_BIN.getTrades();
            for (class_3222 player : server.method_3760().method_14571()) {
                this.sendTradesToClient(player);
            }
        }
        if (server.method_3780() % 10 == 0) {
            for (class_3222 player : server.method_3760().method_14571()) {
                this.sendEntriesToClient(player);
            }
        }
        this.entries.forEach((uuid, entries) -> entries.forEach((id, entry) -> {
            BinMaterial material = BinMaterial.of(id);
            if (material == null) {
                return;
            }
            if (entry.getTimeLeft() > material.getUpdateDelayTicks()) {
                entry.setTimeLeft(material.getUpdateDelayTicks());
            }
            if (entry.getTimeLeft() < 0L) {
                entry.inventory.executeTrades();
                entry.setTimeLeft(material.getUpdateDelayTicks());
            }
            entry.setTimeLeft(entry.getTimeLeft() - 1L);
        }));
    }

    public void sendTradesToClient(class_3222 player) {
        ModNetwork.CHANNEL.sendToPlayer(player, (Object)new SellingBinTradesS2CPacket(ModConfigs.SELLING_BIN.getTrades()));
    }

    public void sendEntriesToClient(class_3222 player) {
        HashMap<String, Integer> timeLeft = new HashMap<String, Integer>();
        ((Map)this.entries.getOrDefault(player.method_5667(), new HashMap())).forEach((key, value) -> timeLeft.put((String)key, (int)value.getTimeLeft()));
        if (!timeLeft.isEmpty()) {
            ModNetwork.CHANNEL.sendToPlayer(player, (Object)new SellingBinEntriesS2CPacket(timeLeft));
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        class_2487 entriesNbt = new class_2487();
        this.entries.forEach((uuid, entries) -> {
            class_2487 entryNbt = new class_2487();
            entries.forEach((id, entry) -> entry.writeNbt().ifPresent(tag -> entryNbt.method_10566(id, (class_2520)tag)));
            entriesNbt.method_10566(uuid.toString(), (class_2520)entryNbt);
        });
        nbt.method_10566("entries", (class_2520)entriesNbt);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2487 entriesNbt = nbt.method_10562("entries");
        this.entries.clear();
        for (String key : entriesNbt.method_10541()) {
            UUID uuid = UUID.fromString(key);
            HashMap<String, Entry> map = new HashMap<String, Entry>();
            class_2487 entryNbt = entriesNbt.method_10562(key);
            for (String key2 : entryNbt.method_10541()) {
                Entry entry = new Entry();
                entry.readNbt(entryNbt.method_10562(key2));
                map.put(key2, entry);
            }
            this.entries.put(uuid, map);
        }
    }

    public boolean method_79() {
        return true;
    }

    public static void initCommon() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            SellingBinData data = ModWorldData.SELLING_BIN.getGlobal((class_1937)player.method_51469());
            data.sendTradesToClient(player);
            data.sendEntriesToClient(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            SellingBinData data = ModWorldData.SELLING_BIN.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    static {
        CLIENT_TIME_LEFT = new HashMap<String, Integer>();
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private final SellingBinInventory inventory = new SellingBinInventory(null, 0);
        private long timeLeft = 0L;

        public SellingBinInventory getInventory() {
            return this.inventory;
        }

        public long getTimeLeft() {
            return this.timeLeft;
        }

        public void setTimeLeft(long timeLeft) {
            this.timeLeft = timeLeft;
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                this.inventory.writeNbt().ifPresent(tag -> nbt.method_10566("inventory", (class_2520)tag));
                Adapters.LONG.writeNbt(this.timeLeft).ifPresent(tag -> nbt.method_10566("timeLeft", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.inventory.readNbt(nbt.method_10562("inventory"));
            this.timeLeft = Adapters.LONG.readNbt(nbt.method_10580("timeLeft")).orElse(0L);
        }
    }
}

