/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.trade;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import bigchadguys.sellingbin.data.item.ItemPredicate;
import bigchadguys.sellingbin.data.item.PartialItem;
import bigchadguys.sellingbin.data.item.PartialItemGroup;
import bigchadguys.sellingbin.data.item.PartialItemTag;
import bigchadguys.sellingbin.data.item.PartialStack;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import bigchadguys.sellingbin.data.serializable.ISerializable;
import bigchadguys.sellingbin.data.tile.OrItemPredicate;
import bigchadguys.sellingbin.init.ModBlocks;
import bigchadguys.sellingbin.init.ModConfigs;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class Trade
implements ISerializable<class_2487, JsonObject> {
    public static final Trade ERROR = new Trade(new Input(PartialItem.of(new class_2960("sellingbin:error")), 1), PartialStack.of(PartialItem.of(new class_2960("sellingbin:error")), PartialCompoundNbt.empty()));
    private final Input input;
    private PartialStack output;

    public Trade() {
        this.input = new Input();
    }

    public Trade(Input input, PartialStack output) {
        this.input = input;
        this.output = output;
    }

    public Input getInput() {
        return this.input;
    }

    public PartialStack getOutput() {
        return this.output;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        this.input.writeBits(buffer);
        Adapters.PARTIAL_STACK.writeBits(this.output, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.input.readBits(buffer);
        this.output = (PartialStack)Adapters.PARTIAL_STACK.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        this.input.writeNbt().ifPresent(value -> nbt.method_10566("input", (class_2520)value));
        Adapters.PARTIAL_STACK.writeNbt(this.output).ifPresent(value -> nbt.method_10566("output", value));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.input.readNbt(nbt.method_10562("input"));
        this.output = Adapters.PARTIAL_STACK.readNbt(nbt.method_10580("output")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        this.input.writeJson().ifPresent(value -> json.add("input", (JsonElement)value));
        Adapters.PARTIAL_STACK.writeJson(this.output).ifPresent(value -> json.add("output", value));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.input.readJson(json.getAsJsonObject("input"));
        this.output = Adapters.PARTIAL_STACK.readJson(json.get("output")).orElseThrow();
    }

    public void validate(String path) {
        this.input.filter.validate(path + ".input");
        this.output.validate(path + ".output");
    }

    public static class Input
    implements ISerializable<class_2487, JsonObject> {
        private ItemPredicate filter;
        private int count;
        private List<Entry> cache;

        public Input() {
        }

        public Input(ItemPredicate filter, int count) {
            this.filter = filter;
            this.count = count;
        }

        public ItemPredicate getFilter() {
            return this.filter;
        }

        public int getCount() {
            return this.count;
        }

        public class_1799 getDisplay(double time) {
            if (this.cache == null) {
                this.cache = new ArrayList<Entry>();
                this.iterate(this.filter, new class_2487(), this.cache);
            }
            if (this.cache.isEmpty()) {
                return new class_1799((class_1935)class_1802.field_8162, this.count);
            }
            int index = (int)(time / 30.0) % this.cache.size();
            return this.cache.get(index).toStack(this.count);
        }

        private void iterate(ItemPredicate filter, class_2487 nbt, List<Entry> entries) {
            if (filter instanceof OrItemPredicate) {
                OrItemPredicate or = (OrItemPredicate)filter;
                for (ItemPredicate predicate : or.getChildren()) {
                    this.iterate(predicate, nbt, entries);
                }
            } else if (filter instanceof PartialItem) {
                PartialItem item = (PartialItem)filter;
                entries.add(new Entry(item.asWhole().orElse(((class_2248)ModBlocks.ERROR.get()).method_8389()), null));
            } else if (filter instanceof PartialItemGroup) {
                PartialItemGroup group = (PartialItemGroup)filter;
                for (ItemPredicate child : ModConfigs.ITEM_GROUPS.getGroup(group.getId())) {
                    class_2487 copy = nbt.method_10553();
                    group.getNbt().asWhole().ifPresent(arg_0 -> ((class_2487)copy).method_10543(arg_0));
                    this.iterate(child, copy, entries);
                }
            } else if (filter instanceof PartialItemTag) {
                PartialItemTag tag = (PartialItemTag)filter;
                class_2487 copy = nbt.method_10553();
                tag.getNbt().asWhole().ifPresent(arg_0 -> ((class_2487)copy).method_10543(arg_0));
                for (class_1792 item : class_7923.field_41178) {
                    if (!class_7923.field_41178.method_47983((Object)item).method_40228().anyMatch(itemTagKey -> tag.getId().equals((Object)itemTagKey.comp_327()))) continue;
                    entries.add(new Entry(item, copy));
                }
            } else if (filter instanceof PartialStack) {
                PartialStack stack = (PartialStack)filter;
                class_1799 _stack = stack.generate(this.count).orElseGet(() -> new class_1799((class_1935)((class_2248)ModBlocks.ERROR.get()).method_8389(), this.count));
                entries.add(new Entry(_stack.method_7909(), _stack.method_7969()));
            }
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.ITEM_PREDICATE.writeBits(this.filter, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.filter = Adapters.ITEM_PREDICATE.readBits(buffer).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<class_2487> writeNbt() {
            class_2487 nbt = new class_2487();
            Adapters.ITEM_PREDICATE.writeNbt(this.filter).ifPresent(value -> nbt.method_10566("filter", value));
            Adapters.INT_SEGMENTED_3.writeNbt(this.count).ifPresent(value -> nbt.method_10566("count", value));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.filter = Adapters.ITEM_PREDICATE.readNbt(nbt.method_10580("filter")).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readNbt(nbt.method_10580("count")).orElseThrow();
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.ITEM_PREDICATE.writeJson(this.filter).ifPresent(value -> json.add("filter", value));
            Adapters.INT_SEGMENTED_3.writeJson(this.count).ifPresent(value -> json.add("count", value));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            this.filter = Adapters.ITEM_PREDICATE.readJson(json.get("filter")).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readJson(json.get("count")).orElseThrow();
        }

        private record Entry(class_1792 item, class_2487 nbt) {
            public class_1799 toStack(int count) {
                class_1799 stack = new class_1799((class_1935)this.item, count);
                stack.method_7980(this.nbt);
                return stack;
            }
        }
    }
}

