/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.net;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import bigchadguys.sellingbin.net.ModPacket;
import bigchadguys.sellingbin.trade.Trade;
import bigchadguys.sellingbin.world.data.SellingBinData;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_634;

public class SellingBinTradesS2CPacket
extends ModPacket<class_634> {
    private final List<Trade> trades;

    public SellingBinTradesS2CPacket() {
        this.trades = new ArrayList<Trade>();
    }

    public SellingBinTradesS2CPacket(List<Trade> trades) {
        this.trades = trades;
    }

    @Override
    public void onReceive(class_634 listener) {
        SellingBinData.CLIENT_TRADES = this.trades;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_7.writeBits(this.trades.size(), buffer);
        this.trades.forEach(trade -> {
            JsonElement json = (JsonElement)Adapters.TRADE.writeJson((Trade)trade).orElseThrow();
            Adapters.UTF_8.writeBits(json.toString(), buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.trades.clear();
        int size = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            JsonElement json = JsonParser.parseString((String)Adapters.UTF_8.readBits(buffer).orElseThrow());
            this.trades.add((Trade)Adapters.TRADE.readJson(json).orElseThrow());
        }
    }
}

