/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.tile;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import bigchadguys.sellingbin.data.tile.PartialBlockState;
import bigchadguys.sellingbin.data.tile.TilePlacement;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class PartialTile
implements TilePlacement<PartialTile> {
    public static PartialTile ERROR = PartialTile.of(PartialBlockState.parse("sellingbin:error", true).orElseThrow(), PartialCompoundNbt.empty(), null);
    protected PartialBlockState state;
    protected PartialCompoundNbt entity;
    protected class_2338 pos;

    protected PartialTile(PartialBlockState state, PartialCompoundNbt entity, class_2338 pos) {
        this.state = state;
        this.entity = entity;
        this.pos = pos;
    }

    public static PartialTile of(PartialBlockState state, PartialCompoundNbt entity, class_2338 pos) {
        return new PartialTile(state, entity, pos);
    }

    public static PartialTile of(PartialBlockState state, PartialCompoundNbt entity) {
        return new PartialTile(state, entity, null);
    }

    public static PartialTile at(class_1922 world, class_2338 pos) {
        return new PartialTile(PartialBlockState.at(world, pos), PartialCompoundNbt.at(world, pos), pos);
    }

    public static PartialTile of(class_2680 state) {
        return new PartialTile(PartialBlockState.of(state), PartialCompoundNbt.empty(), null);
    }

    public PartialBlockState getState() {
        return this.state;
    }

    public PartialCompoundNbt getEntity() {
        return this.entity;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public PartialTile setState(PartialBlockState state) {
        this.state = state;
        return this;
    }

    public PartialTile setEntity(PartialCompoundNbt entity) {
        this.entity = entity;
        return this;
    }

    public PartialTile setPos(class_2338 pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public boolean isSubsetOf(PartialTile other) {
        if (!this.state.isSubsetOf(other.state)) {
            return false;
        }
        return this.entity.isSubsetOf(other.entity);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        if (!this.state.isSubsetOf(world, pos)) {
            return false;
        }
        return this.entity.isSubsetOf(world, pos);
    }

    @Override
    public void fillInto(PartialTile other) {
        this.state.fillInto(other.state);
        this.entity.fillInto(other.entity);
        if (this.pos != null) {
            other.pos = this.pos.method_10062();
        }
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        if (pos != null) {
            this.state.place(world, pos, flags);
            this.entity.place(world, pos, flags);
        } else if (this.pos != null) {
            this.state.place(world, this.pos, flags);
            this.entity.place(world, this.pos, flags);
        }
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(PartialTile.of(state, nbt, null));
    }

    @Override
    public PartialTile copy() {
        return new PartialTile(this.state.copy(), this.entity.copy(), this.pos == null ? null : this.pos.method_10062());
    }

    public String toString() {
        return this.state.toString() + this.entity.toString();
    }

    public static Optional<PartialTile> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialTile.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialTile parse(String string) throws CommandSyntaxException {
        return PartialTile.parse(new StringReader(string));
    }

    public static PartialTile parse(StringReader reader) throws CommandSyntaxException {
        return PartialTile.of(PartialBlockState.parse(reader), PartialCompoundNbt.parse(reader), null);
    }

    public static class Adapter
    implements ISimpleAdapter<PartialTile, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialTile value) {
            if (value == null) {
                return Optional.empty();
            }
            class_2487 nbt = new class_2487();
            if (value.pos != null) {
                class_2499 posNBT = new class_2499();
                posNBT.add((Object)class_2497.method_23247((int)value.pos.method_10263()));
                posNBT.add((Object)class_2497.method_23247((int)value.pos.method_10264()));
                posNBT.add((Object)class_2497.method_23247((int)value.pos.method_10260()));
                nbt.method_10566("pos", (class_2520)posNBT);
            }
            Adapters.PARTIAL_BLOCK_STATE.writeNbt(value.state).ifPresent(tag -> nbt.method_10566("state", tag));
            Adapters.PARTIAL_NBT.writeNbt(value.entity).ifPresent(tag -> nbt.method_10566("nbt", tag));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialTile> readNbt(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                PartialBlockState state = Adapters.PARTIAL_BLOCK_STATE.readNbt(compound.method_10580("state")).orElseThrow();
                PartialCompoundNbt entity = Adapters.PARTIAL_NBT.readNbt(compound.method_10580("nbt")).orElseGet(PartialCompoundNbt::empty);
                class_2338 pos = null;
                if (compound.method_10573("pos", 9)) {
                    class_2499 posNBT = compound.method_10554("pos", 3);
                    pos = new class_2338(posNBT.method_10600(0), posNBT.method_10600(1), posNBT.method_10600(2));
                }
                return Optional.of(PartialTile.of(state, entity, pos));
            }
            return Optional.empty();
        }
    }
}

