/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.tile;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import bigchadguys.sellingbin.data.tile.PartialBlock;
import bigchadguys.sellingbin.data.tile.PartialBlockProperties;
import bigchadguys.sellingbin.data.tile.TilePlacement;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PartialBlockState
implements TilePlacement<PartialBlockState> {
    private PartialBlock block;
    private PartialBlockProperties properties;

    protected PartialBlockState(PartialBlock block, PartialBlockProperties properties) {
        this.block = block;
        this.properties = properties;
    }

    public static PartialBlockState of(PartialBlock block, PartialBlockProperties properties) {
        return new PartialBlockState(block, properties);
    }

    public static PartialBlockState of(class_2248 block) {
        return new PartialBlockState(PartialBlock.of(block), PartialBlockProperties.empty());
    }

    public static PartialBlockState of(class_2680 state) {
        return new PartialBlockState(PartialBlock.of(state), PartialBlockProperties.of(state));
    }

    public static PartialBlockState at(class_1922 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return new PartialBlockState(PartialBlock.of(state), PartialBlockProperties.of(state));
    }

    public PartialBlock getBlock() {
        return this.block;
    }

    public PartialBlockProperties getProperties() {
        return this.properties;
    }

    public <T extends Comparable<T>> T get(class_2769<T> property) {
        return this.properties.get(property);
    }

    public <T extends Comparable<T>, V extends T> PartialBlockState set(class_2769<T> property, V value) {
        this.properties.set(property, value);
        return this;
    }

    @Override
    public boolean isSubsetOf(PartialBlockState other) {
        if (!this.block.isSubsetOf(other.block)) {
            return false;
        }
        return this.properties.isSubsetOf(other.properties);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        return this.isSubsetOf(PartialBlockState.of(world.method_8320(pos)));
    }

    @Override
    public void fillInto(PartialBlockState other) {
        this.block.fillInto(other.block);
        this.properties.fillInto(other.properties);
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        this.asWhole().ifPresent(state -> world.method_8652(pos, state, flags));
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state);
    }

    public Optional<class_2680> asWhole() {
        return this.block.asWhole().map(block -> this.properties.apply(block.method_9564()));
    }

    public void mapAndSet(UnaryOperator<class_2680> mapper) {
        this.asWhole().ifPresent(oldState -> {
            class_2680 newState = (class_2680)mapper.apply((class_2680)oldState);
            if (oldState == newState) {
                return;
            }
            PartialBlock.of(newState.method_26204()).fillInto(this.block);
            PartialBlockProperties.of(newState).fillInto(this.properties);
        });
    }

    public void mirror(class_2415 mirror) {
        this.mapAndSet(state -> state.method_26185(mirror));
    }

    public void rotate(class_2470 rotation) {
        this.mapAndSet(state -> state.method_26186(rotation));
    }

    public boolean is(class_2248 block) {
        return this.block.asWhole().map(value -> block == value).orElse(false);
    }

    @Override
    public PartialBlockState copy() {
        return PartialBlockState.of(this.block.copy(), this.properties.copy());
    }

    public String toString() {
        return this.block.toString() + this.properties.toString();
    }

    public static Optional<PartialBlockState> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlockState.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlockState parse(String string) throws CommandSyntaxException {
        return PartialBlockState.parse(new StringReader(string));
    }

    public static PartialBlockState parse(StringReader reader) throws CommandSyntaxException {
        return PartialBlockState.of(PartialBlock.parse(reader), PartialBlockProperties.parse(reader));
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlockState, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialBlockState value) {
            if (value == null) {
                return Optional.empty();
            }
            class_2487 nbt = new class_2487();
            Adapters.PARTIAL_BLOCK.writeNbt(value.block).ifPresent(tag -> nbt.method_10566("Name", tag));
            Adapters.PARTIAL_BLOCK_PROPERTIES.writeNbt(value.properties).ifPresent(tag -> nbt.method_10566("Properties", tag));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialBlockState> readNbt(class_2520 nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                return Optional.of(PartialBlockState.of(Adapters.PARTIAL_BLOCK.readNbt(compound.method_10580("Name")).orElseGet(PartialBlock::empty), Adapters.PARTIAL_BLOCK_PROPERTIES.readNbt(compound.method_10580("Properties")).orElseGet(PartialBlockProperties::empty)));
            }
            return Optional.empty();
        }
    }
}

