/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.tile;

import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import bigchadguys.sellingbin.data.tile.PartialBlockState;
import bigchadguys.sellingbin.data.tile.TilePlacement;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

public class PartialBlockProperties
implements TilePlacement<PartialBlockProperties> {
    private final Map<String, String> properties;

    protected PartialBlockProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static PartialBlockProperties empty() {
        return new PartialBlockProperties(new HashMap<String, String>());
    }

    public static PartialBlockProperties of(Map<String, String> properties) {
        return new PartialBlockProperties(properties);
    }

    public static PartialBlockProperties of(class_2680 state) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (class_2769 property : state.method_28501()) {
            properties.put(property.method_11899(), property.method_11901(state.method_11654(property)));
        }
        return new PartialBlockProperties(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public <T extends Comparable<T>> T get(class_2769<T> property) {
        return (T)((Comparable)property.method_11900(this.properties.get(property.method_11899())).orElse(null));
    }

    public <T extends Comparable<T>, V extends T> PartialBlockProperties set(class_2769<T> property, V value) {
        this.properties.put(property.method_11899(), property.method_11901(value));
        return this;
    }

    @Override
    public boolean isSubsetOf(PartialBlockProperties other) {
        if (other == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (entry.getValue().equals(other.properties.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        return this.isSubsetOf(PartialBlockProperties.of(world.method_8320(pos)));
    }

    @Override
    public void fillInto(PartialBlockProperties other) {
        other.properties.putAll(this.properties);
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        class_2680 newState;
        class_2680 oldState = world.method_8320(pos);
        if (oldState != (newState = this.apply(oldState))) {
            world.method_8652(pos, newState, flags);
        }
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state.getProperties());
    }

    public class_2680 apply(class_2680 state) {
        class_2689 definition = state.method_26204().method_9595();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            Optional value;
            class_2769 property = definition.method_11663(entry.getKey());
            if (property == null || !state.method_28498(property) || (value = property.method_11900(entry.getValue())).isEmpty()) continue;
            state = (class_2680)state.method_11657(property, (Comparable)value.get());
        }
        return state;
    }

    @Override
    public PartialBlockProperties copy() {
        return new PartialBlockProperties(new HashMap<String, String>(this.properties));
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.append(']').toString();
    }

    public static Optional<PartialBlockProperties> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlockProperties.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlockProperties parse(String string) throws CommandSyntaxException {
        return PartialBlockProperties.parse(new StringReader(string));
    }

    public static PartialBlockProperties parse(StringReader reader) throws CommandSyntaxException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!reader.canRead() || reader.peek() != '[') {
            return PartialBlockProperties.of(properties);
        }
        reader.skip();
        int cursor = -1;
        reader.skipWhitespace();
        while (reader.canRead() && reader.peek() != ']') {
            reader.skipWhitespace();
            String key = reader.readString();
            int prevCursor = reader.getCursor();
            reader.skipWhitespace();
            if (properties.containsKey(key)) {
                reader.setCursor(cursor);
                throw new IllegalArgumentException("Duplicate property <" + key + "> in tile '" + reader.getString() + "'");
            }
            if (!reader.canRead() || reader.peek() != '=') {
                reader.setCursor(prevCursor);
                throw new IllegalArgumentException("Empty property <" + key + "> in tile '" + reader.getString() + "'");
            }
            reader.skip();
            reader.skipWhitespace();
            cursor = reader.getCursor();
            String value = reader.readString();
            properties.put(key, value);
            reader.skipWhitespace();
            if (!reader.canRead()) continue;
            cursor = -1;
            if (reader.peek() == ',') {
                reader.skip();
                continue;
            }
            if (reader.peek() == ']') break;
            throw new IllegalArgumentException("Unclosed properties in tile '" + reader.getString() + "'");
        }
        if (reader.canRead()) {
            reader.skip();
            return PartialBlockProperties.of(properties);
        }
        if (cursor >= 0) {
            reader.setCursor(cursor);
        }
        throw new IllegalArgumentException("Unclosed properties in tile '" + reader.getString() + "'");
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlockProperties, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialBlockProperties value) {
            if (value == null || value.properties.isEmpty()) {
                return Optional.empty();
            }
            class_2487 nbt = new class_2487();
            value.properties.forEach((arg_0, arg_1) -> ((class_2487)nbt).method_10582(arg_0, arg_1));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialBlockProperties> readNbt(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String key : compound.method_10541()) {
                    class_2520 class_25202 = compound.method_10580(key);
                    if (!(class_25202 instanceof class_2519)) continue;
                    class_2519 string = (class_2519)class_25202;
                    properties.put(key, string.method_10714());
                }
                return Optional.of(PartialBlockProperties.of(properties));
            }
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                return PartialBlockProperties.parse(string.method_10714(), true);
            }
            return Optional.empty();
        }
    }
}

