/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.tile;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import bigchadguys.sellingbin.data.tile.PartialBlockState;
import bigchadguys.sellingbin.data.tile.TilePlacement;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartialBlock
implements TilePlacement<PartialBlock> {
    protected class_2960 id;

    protected PartialBlock(class_2960 id) {
        this.id = id;
    }

    public static PartialBlock empty() {
        return new PartialBlock(null);
    }

    public static PartialBlock of(class_2960 id) {
        return new PartialBlock(id);
    }

    public static PartialBlock of(class_2248 block) {
        return new PartialBlock(class_7923.field_41175.method_10221((Object)block));
    }

    public static PartialBlock of(class_2680 state) {
        return new PartialBlock(class_7923.field_41175.method_10221((Object)state.method_26204()));
    }

    @Override
    public boolean isSubsetOf(PartialBlock other) {
        return this.id == null || this.id.equals((Object)other.id);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        return this.isSubsetOf(PartialBlock.of(world.method_8320(pos).method_26204()));
    }

    @Override
    public void fillInto(PartialBlock other) {
        if (this.id == null) {
            return;
        }
        other.id = this.id;
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        this.asWhole().ifPresent(block -> {
            class_2680 oldState = world.method_8320(pos);
            class_2680 newState = block.method_9564();
            for (class_2769 property : oldState.method_28501()) {
                if (!newState.method_28498(property)) continue;
                newState = (class_2680)newState.method_11657(property, oldState.method_11654(property));
            }
            world.method_8652(pos, newState, flags);
        });
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state.getBlock());
    }

    public Optional<class_2248> asWhole() {
        if (!class_7923.field_41175.method_10250(this.id)) {
            return Optional.empty();
        }
        return class_7923.field_41175.method_17966(this.id);
    }

    @Override
    public PartialBlock copy() {
        return new PartialBlock(this.id);
    }

    public String toString() {
        return this.id == null ? "" : this.id.toString();
    }

    public static Optional<PartialBlock> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlock.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlock parse(String string) throws CommandSyntaxException {
        return PartialBlock.parse(new StringReader(string));
    }

    public static PartialBlock parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialBlock.isCharValid(reader.peek())) {
            return PartialBlock.empty();
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBlock.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBlock.of(new class_2960(string));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid block identifier '" + string + "' in tile '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlock, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialBlock value) {
            return value == null ? Optional.empty() : Adapters.IDENTIFIER.writeNbt(value.id);
        }

        @Override
        public Optional<PartialBlock> readNbt(class_2520 nbt) {
            return nbt == null ? Optional.empty() : Adapters.IDENTIFIER.readNbt(nbt).map(PartialBlock::of);
        }
    }
}

