/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.item;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.item.ItemPlacement;
import bigchadguys.sellingbin.data.item.PartialItem;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class PartialStack
implements ItemPlacement<PartialStack> {
    protected PartialItem item;
    protected PartialCompoundNbt nbt;
    protected int count;

    protected PartialStack(PartialItem item, PartialCompoundNbt nbt, int count) {
        this.item = item;
        this.nbt = nbt;
        this.count = count;
    }

    public static PartialStack of(PartialItem item, PartialCompoundNbt nbt) {
        return new PartialStack(item, nbt, 1);
    }

    public static PartialStack of(class_1799 stack) {
        return new PartialStack(PartialItem.of(stack), PartialCompoundNbt.of(stack), 1);
    }

    public PartialItem getItem() {
        return this.item;
    }

    public PartialCompoundNbt getNbt() {
        return this.nbt;
    }

    public int getCount() {
        return this.count;
    }

    public void setItem(PartialItem item) {
        this.item = item;
    }

    public void setNbt(PartialCompoundNbt nbt) {
        this.nbt = nbt;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public boolean isSubsetOf(PartialStack other) {
        if (!this.item.isSubsetOf(other.item)) {
            return false;
        }
        return this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(class_1799 stack) {
        if (!this.item.isSubsetOf(stack)) {
            return false;
        }
        return this.nbt.isSubsetOf(stack);
    }

    @Override
    public void fillInto(PartialStack other) {
        this.item.fillInto(other.item);
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public Optional<class_1799> generate(int count) {
        return this.item.generate(count).map(stack -> {
            stack.method_7980((class_2487)this.nbt.asWhole().orElse(null));
            return stack;
        });
    }

    public Optional<class_1799> generate() {
        return this.generate(this.count);
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(PartialStack.of(item, nbt));
    }

    @Override
    public void validate(String path) {
        this.item.validate(path + ".item");
        this.nbt.validate(path + ".nbt");
    }

    @Override
    public PartialStack copy() {
        return new PartialStack(this.item.copy(), this.nbt.copy(), this.count);
    }

    public String toString() {
        return this.item.toString() + this.nbt.toString();
    }

    public static Optional<PartialStack> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialStack.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialStack parse(String string) throws CommandSyntaxException {
        return PartialStack.parse(new StringReader(string));
    }

    public static PartialStack parse(StringReader reader) throws CommandSyntaxException {
        return PartialStack.of(PartialItem.parse(reader), PartialCompoundNbt.parse(reader));
    }

    public static class Adapter
    implements ISimpleAdapter<PartialStack, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialStack value) {
            if (value == null) {
                return Optional.empty();
            }
            class_2487 nbt = new class_2487();
            Adapters.PARTIAL_ITEM.writeNbt(value.item).ifPresent(tag -> nbt.method_10566("item", tag));
            Adapters.PARTIAL_NBT.writeNbt(value.nbt).ifPresent(tag -> nbt.method_10566("nbt", tag));
            if (value.count != 1) {
                Adapters.INT.writeNbt(value.count).ifPresent(tag -> nbt.method_10566("count", tag));
            }
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialStack> readNbt(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                PartialItem item = Adapters.PARTIAL_ITEM.readNbt(compound.method_10580("item")).orElseThrow();
                PartialCompoundNbt tag = Adapters.PARTIAL_NBT.readNbt(compound.method_10580("nbt")).orElseGet(PartialCompoundNbt::empty);
                int count = Adapters.INT.readNbt(compound.method_10580("count")).orElse(1);
                return Optional.of(new PartialStack(item, tag, count));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(PartialStack value) {
            if (value == null) {
                return Optional.empty();
            }
            JsonObject nbt = new JsonObject();
            Adapters.PARTIAL_ITEM.writeJson(value.item).ifPresent(tag -> nbt.add("item", tag));
            Adapters.PARTIAL_NBT.writeJson(value.nbt).ifPresent(tag -> nbt.add("nbt", tag));
            if (value.count != 1) {
                Adapters.INT.writeJson(value.count).ifPresent(tag -> nbt.add("count", tag));
            }
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialStack> readJson(JsonElement nbt) {
            if (nbt instanceof JsonObject) {
                JsonObject object = (JsonObject)nbt;
                PartialItem item = Adapters.PARTIAL_ITEM.readJson(object.get("item")).orElseThrow();
                PartialCompoundNbt tag = Adapters.PARTIAL_NBT.readJson(object.get("nbt")).orElseGet(PartialCompoundNbt::empty);
                int count = Adapters.INT.readJson(object.get("count")).orElse(1);
                return Optional.of(new PartialStack(item, tag, count));
            }
            return Optional.empty();
        }
    }
}

