/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.item;

import bigchadguys.sellingbin.SellingBinMod;
import bigchadguys.sellingbin.data.item.ItemPlacement;
import bigchadguys.sellingbin.data.item.PartialItem;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartialItemTag
implements ItemPlacement<PartialItemTag> {
    private class_2960 id;
    private PartialCompoundNbt nbt;

    public PartialItemTag(class_2960 id, PartialCompoundNbt nbt) {
        this.id = id;
        this.nbt = nbt;
    }

    public class_2960 getId() {
        return this.id;
    }

    public PartialCompoundNbt getNbt() {
        return this.nbt;
    }

    public static PartialItemTag of(class_2960 id, PartialCompoundNbt entity) {
        return new PartialItemTag(id, entity);
    }

    @Override
    public boolean isSubsetOf(PartialItemTag other) {
        return (this.id == null || this.id.equals((Object)other.id)) && this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillInto(PartialItemTag other) {
        if (this.id != null) {
            other.id = this.id;
        }
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public Optional<class_1799> generate(int count) {
        return this.nbt.generate(count);
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.nbt.isSubsetOf(nbt) && item.asWhole().map(other -> class_7923.field_41178.method_47983(other).method_40228().anyMatch(tag -> tag.comp_327().equals((Object)this.id))).orElse(false) != false;
    }

    @Override
    public void validate(String path) {
        boolean used = false;
        for (class_1792 item : class_7923.field_41178) {
            if (!class_7923.field_41178.method_47983((Object)item).method_40228().anyMatch(key -> this.getId().equals((Object)key.comp_327()))) continue;
            used = true;
            break;
        }
        if (!used) {
            SellingBinMod.LOGGER.error("%s: Unused item tag <%s>".formatted(path, this.id));
        }
    }

    @Override
    public PartialItemTag copy() {
        return new PartialItemTag(this.id, this.nbt.copy());
    }

    public String toString() {
        return "#" + (Comparable)((Object)(this.id == null ? "" : this.id)) + this.nbt.toString();
    }

    public static Optional<PartialItemTag> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialItemTag.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialItemTag parse(String string) throws CommandSyntaxException {
        return PartialItemTag.parse(new StringReader(string));
    }

    public static PartialItemTag parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '#') {
            throw new IllegalArgumentException("Invalid item tag '" + reader.getString() + "' does not start with #");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialItemTag.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialItemTag.of(new class_2960(string), PartialCompoundNbt.parse(reader));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid tag identifier '" + string + "' in item tag '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

