/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.entity;

import bigchadguys.sellingbin.data.entity.EntityPlacement;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import bigchadguys.sellingbin.init.ModConfigs;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class PartialEntityGroup
implements EntityPlacement<PartialEntityGroup> {
    private class_2960 id;
    private PartialCompoundNbt nbt;

    public PartialEntityGroup(class_2960 id, PartialCompoundNbt nbt) {
        this.id = id;
        this.nbt = nbt;
    }

    public static PartialEntityGroup of(class_2960 id, PartialCompoundNbt entity) {
        return new PartialEntityGroup(id, entity);
    }

    @Override
    public boolean isSubsetOf(PartialEntityGroup other) {
        return (this.id == null || this.id.equals((Object)other.id)) && this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(class_1297 entity) {
        return false;
    }

    @Override
    public void fillInto(PartialEntityGroup other) {
        if (this.id != null) {
            other.id = this.id;
        }
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public void place(class_1945 world) {
    }

    @Override
    public boolean test(class_243 pos, class_2338 blockPos, PartialCompoundNbt nbt) {
        return this.nbt.isSubsetOf(nbt) && ModConfigs.ENTITY_GROUPS.isInGroup(this.id, pos, blockPos, nbt);
    }

    @Override
    public PartialEntityGroup copy() {
        return new PartialEntityGroup(this.id, this.nbt.copy());
    }

    public String toString() {
        return (String)(this.id != null ? "@" + this.id : "") + this.nbt.toString();
    }

    public static Optional<PartialEntityGroup> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialEntityGroup.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialEntityGroup parse(String string) throws CommandSyntaxException {
        return PartialEntityGroup.parse(new StringReader(string));
    }

    public static PartialEntityGroup parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '@') {
            throw new IllegalArgumentException("Invalid entity group '" + reader.getString() + "' does not start with @");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialEntityGroup.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialEntityGroup.of(new class_2960(string), PartialCompoundNbt.parse(reader));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid group identifier '" + string + "' in entity group '" + reader.getString() + "'");
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialEntityGroup that = (PartialEntityGroup)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

