/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.adapter.number;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.number.BoundedIntAdapter;
import bigchadguys.sellingbin.data.adapter.number.NumberAdapter;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class NumericAdapter
extends NumberAdapter<Number> {
    private static NumberAdapter[] ADAPTERS = new NumberAdapter[]{Adapters.BYTE, Adapters.SHORT, Adapters.INT, Adapters.FLOAT, Adapters.LONG, Adapters.DOUBLE, Adapters.BIG_INTEGER, Adapters.BIG_DECIMAL};
    private static final BoundedIntAdapter ID = new BoundedIntAdapter(0, ADAPTERS.length - 1, false);
    private static final Object2IntMap<Class<?>> TYPE_TO_ID = new Object2IntOpenHashMap();

    public NumericAdapter(boolean nullable) {
        super(nullable);
    }

    public NumericAdapter asNullable() {
        return new NumericAdapter(true);
    }

    @Override
    protected void writeNumberBits(Number value, BitBuffer buffer) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeBits(id, buffer);
        ADAPTERS[id].writeBits(value, buffer);
    }

    @Override
    protected Number readNumberBits(BitBuffer buffer) {
        int id = (Integer)ID.readBits(buffer).orElseThrow();
        return ADAPTERS[id].readBits(buffer).orElse(null);
    }

    @Override
    protected void writeNumberBytes(Number value, ByteBuf buffer) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeBytes(id, buffer);
        ADAPTERS[id].writeBytes(value, buffer);
    }

    @Override
    protected Number readNumberBytes(ByteBuf buffer) {
        int id = (Integer)ID.readBytes(buffer).orElseThrow();
        return ADAPTERS[id].readBytes(buffer).orElse(null);
    }

    @Override
    protected void writeNumberData(Number value, DataOutput data) throws IOException {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeData(id, data);
        ADAPTERS[id].writeData(value, data);
    }

    @Override
    protected Number readNumberData(DataInput data) throws IOException {
        int id = (Integer)ID.readData(data).orElseThrow();
        return ADAPTERS[id].readData(data).orElse(null);
    }

    @Override
    protected class_2520 writeNumberNbt(Number value) {
        return NumericAdapter.wrap(NumericAdapter.reduce(value));
    }

    @Override
    protected Number readNumberNbt(class_2520 nbt) {
        class_2499 list;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return numeric.method_10702();
        }
        if (nbt instanceof class_2499 && (list = (class_2499)nbt).size() == 1) {
            return this.readNumberNbt(list.method_10534(0));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return NumericAdapter.parse(string.toString()).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(Number value) {
        return new JsonPrimitive(value);
    }

    @Override
    protected Number readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            return NumericAdapter.parse(primitive.getAsString()).orElse(null);
        }
        return null;
    }

    static {
        TYPE_TO_ID.put(Byte.class, 0);
        TYPE_TO_ID.put(Short.class, 1);
        TYPE_TO_ID.put(Integer.class, 2);
        TYPE_TO_ID.put(Float.class, 3);
        TYPE_TO_ID.put(Long.class, 4);
        TYPE_TO_ID.put(Double.class, 5);
        TYPE_TO_ID.put(BigInteger.class, 6);
        TYPE_TO_ID.put(BigDecimal.class, 7);
    }
}

