/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.adapter.number;

import bigchadguys.sellingbin.data.adapter.number.NumberAdapter;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class FloatAdapter
extends NumberAdapter<Float> {
    public FloatAdapter(boolean nullable) {
        super(nullable);
    }

    public FloatAdapter asNullable() {
        return new FloatAdapter(true);
    }

    @Override
    protected void writeNumberBits(Float value, BitBuffer buffer) {
        buffer.writeFloat(value.floatValue());
    }

    @Override
    protected Float readNumberBits(BitBuffer buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    protected void writeNumberBytes(Float value, ByteBuf buffer) {
        buffer.writeFloat(value.floatValue());
    }

    @Override
    protected Float readNumberBytes(ByteBuf buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    protected void writeNumberData(Float value, DataOutput data) throws IOException {
        data.writeFloat(value.floatValue());
    }

    @Override
    protected Float readNumberData(DataInput data) throws IOException {
        return Float.valueOf(data.readFloat());
    }

    @Override
    protected class_2520 writeNumberNbt(Float value) {
        return FloatAdapter.wrap(FloatAdapter.reduce(value));
    }

    @Override
    protected Float readNumberNbt(class_2520 nbt) {
        class_2499 list;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return Float.valueOf(numeric.method_10700());
        }
        if (nbt instanceof class_2499 && (list = (class_2499)nbt).size() == 1) {
            return this.readNumberNbt(list.method_10534(0));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return FloatAdapter.parse(string.method_10714()).map(Number::floatValue).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(Float value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    protected Float readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return Float.valueOf(primitive.getAsFloat());
            }
            if (primitive.isString()) {
                return FloatAdapter.parse(primitive.getAsString()).map(Number::floatValue).orElse(null);
            }
        }
        return null;
    }
}

