/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.adapter.number;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.number.NumberAdapter;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import net.minecraft.class_2479;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class BigIntegerAdapter
extends NumberAdapter<BigInteger> {
    public BigIntegerAdapter(boolean nullable) {
        super(nullable);
    }

    public BigIntegerAdapter asNullable() {
        return new BigIntegerAdapter(true);
    }

    @Override
    protected void writeNumberBits(BigInteger value, BitBuffer buffer) {
        Adapters.BYTE_ARRAY.writeBits(value.toByteArray(), buffer);
    }

    @Override
    protected BigInteger readNumberBits(BitBuffer buffer) {
        return new BigInteger(Adapters.BYTE_ARRAY.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberBytes(BigInteger value, ByteBuf buffer) {
        Adapters.BYTE_ARRAY.writeBytes(value.toByteArray(), buffer);
    }

    @Override
    protected BigInteger readNumberBytes(ByteBuf buffer) {
        return new BigInteger(Adapters.BYTE_ARRAY.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberData(BigInteger value, DataOutput data) throws IOException {
        Adapters.BYTE_ARRAY.writeData(value.toByteArray(), data);
    }

    @Override
    protected BigInteger readNumberData(DataInput data) throws IOException {
        return new BigInteger(Adapters.BYTE_ARRAY.readData(data).orElseThrow());
    }

    @Override
    protected class_2520 writeNumberNbt(BigInteger value) {
        return BigIntegerAdapter.wrap(BigIntegerAdapter.reduce(value));
    }

    @Override
    protected BigInteger readNumberNbt(class_2520 nbt) {
        class_2499 list;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return BigInteger.valueOf(numeric.method_10699());
        }
        if (nbt instanceof class_2479) {
            class_2479 byteArray = (class_2479)nbt;
            return new BigInteger(byteArray.method_10521());
        }
        if (nbt instanceof class_2499 && (list = (class_2499)nbt).size() == 1) {
            return this.readNumberNbt(list.method_10534(0));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return BigIntegerAdapter.parse(string.method_10714()).map(number -> {
                BigInteger value;
                return number instanceof BigInteger ? (value = (BigInteger)number) : BigInteger.valueOf(number.longValue());
            }).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(BigInteger value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    protected BigInteger readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsBigInteger();
            }
            if (primitive.isString()) {
                return BigIntegerAdapter.parse(primitive.getAsString()).map(number -> {
                    BigInteger value;
                    return number instanceof BigInteger ? (value = (BigInteger)number) : BigInteger.valueOf(number.longValue());
                }).orElse(null);
            }
        }
        return null;
    }
}

