/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.adapter.basic;

import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import bigchadguys.sellingbin.data.serializable.ISerializable;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_2520;

public abstract class SupplierAdapter<T extends ISerializable<?, ?>>
implements ISimpleAdapter<T, class_2520, JsonElement> {
    private final boolean nullable;

    public SupplierAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    protected abstract void writeSuppliedBits(T var1, BitBuffer var2);

    protected abstract T readSuppliedBits(BitBuffer var1);

    protected abstract void writeSuppliedBytes(T var1, ByteBuf var2);

    protected abstract T readSuppliedBytes(ByteBuf var1);

    protected abstract void writeSuppliedData(T var1, DataOutput var2) throws IOException;

    protected abstract T readSuppliedData(DataInput var1) throws IOException;

    protected abstract class_2520 writeSuppliedNbt(T var1);

    protected abstract T readSuppliedNbt(class_2520 var1);

    protected abstract JsonElement writeSuppliedJson(T var1);

    protected abstract T readSuppliedJson(JsonElement var1);

    @Override
    public void writeBits(T value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeSuppliedBits(value, buffer);
        }
    }

    @Override
    public Optional<T> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedBits(buffer));
    }

    @Override
    public void writeBytes(T value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeSuppliedBytes(value, buffer);
        }
    }

    @Override
    public Optional<T> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedBytes(buffer));
    }

    @Override
    public void writeData(T value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeSuppliedData(value, data);
        }
    }

    @Override
    public Optional<T> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedData(data));
    }

    @Override
    public Optional<class_2520> writeNbt(T value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeSuppliedNbt(value));
    }

    @Override
    public Optional<T> readNbt(class_2520 nbt) {
        if (nbt == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedNbt(nbt));
    }

    @Override
    public Optional<JsonElement> writeJson(T value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeSuppliedJson(value));
    }

    @Override
    public Optional<T> readJson(JsonElement json) {
        if (json == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedJson(json));
    }
}

