/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.data.adapter.basic;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.adapter.ISimpleAdapter;
import bigchadguys.sellingbin.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class StringAdapter
implements ISimpleAdapter<String, class_2520, JsonElement> {
    private final Charset charset;
    private final boolean nullable;

    public StringAdapter(Charset charset, boolean nullable) {
        this.charset = charset;
        this.nullable = nullable;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public StringAdapter asNullable() {
        return new StringAdapter(this.charset, true);
    }

    @Override
    public void writeBits(String value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeString(value, this.charset);
        }
    }

    @Override
    public Optional<String> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readString(this.charset));
    }

    @Override
    public void writeBytes(String value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            byte[] bytes = value.getBytes(this.charset);
            Adapters.INT_SEGMENTED_7.writeBytes(bytes.length, buffer);
            buffer.writeBytes(bytes);
        }
    }

    @Override
    public Optional<String> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        byte[] bytes = new byte[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        buffer.readBytes(bytes);
        return Optional.of(new String(bytes, this.charset));
    }

    @Override
    public void writeData(String value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            byte[] bytes = value.getBytes(this.charset);
            Adapters.INT_SEGMENTED_7.writeData(bytes.length, data);
            for (byte b : bytes) {
                data.writeByte(b);
            }
        }
    }

    @Override
    public Optional<String> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        byte[] bytes = new byte[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = data.readByte();
        }
        return Optional.of(new String(bytes, this.charset));
    }

    @Override
    public Optional<class_2520> writeNbt(String value) {
        return value == null ? Optional.empty() : Optional.of(class_2519.method_23256((String)value));
    }

    @Override
    public Optional<String> readNbt(class_2520 nbt) {
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return Optional.of(string.method_10714());
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(String value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value));
    }

    @Override
    public Optional<String> readJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            return Optional.of(primitive.getAsString());
        }
        return Optional.empty();
    }
}

