/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.config;

import bigchadguys.sellingbin.block.BinMaterial;
import bigchadguys.sellingbin.block.BinSettings;
import bigchadguys.sellingbin.config.Config;
import bigchadguys.sellingbin.config.FileConfig;
import bigchadguys.sellingbin.data.item.ItemPredicate;
import bigchadguys.sellingbin.data.item.PartialStack;
import bigchadguys.sellingbin.init.ModConfigs;
import bigchadguys.sellingbin.trade.Trade;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class SellingBinConfig
extends FileConfig {
    @Expose
    private Map<BinMaterial, BinSettings> settings;
    @Expose
    private List<Trade> trades;

    public void validate(String path) {
        for (int i = 0; i < this.trades.size(); ++i) {
            Trade trade = this.trades.get(i);
            trade.validate(path + ".trades[" + i + "]");
        }
    }

    public BinSettings getSettings(BinMaterial material) {
        return this.settings.get((Object)material);
    }

    public List<Trade> getTrades() {
        return this.trades;
    }

    @Override
    public String getPath() {
        return "selling_bin";
    }

    @Override
    protected void reset() {
        this.settings = new LinkedHashMap<BinMaterial, BinSettings>();
        this.settings.put(BinMaterial.WOOD, new BinSettings(600L, 1));
        this.settings.put(BinMaterial.REDSTONE, new BinSettings(600L, 2));
        this.settings.put(BinMaterial.IRON, new BinSettings(600L, 2));
        this.settings.put(BinMaterial.DIAMOND, new BinSettings(600L, 3));
        this.settings.put(BinMaterial.NETHERITE, new BinSettings(600L, 6));
        this.trades = new ArrayList<Trade>();
        this.trades.add(new Trade(new Trade.Input(ItemPredicate.of("minecraft:carrot", true).orElseThrow(), 4), PartialStack.of(new class_1799((class_1935)class_1802.field_8687))));
        this.trades.add(new Trade(new Trade.Input(ItemPredicate.of("minecraft:potato", true).orElseThrow(), 4), PartialStack.of(new class_1799((class_1935)class_1802.field_8620))));
    }

    @Override
    public <T extends Config> T read() {
        Object config = super.read();
        ModConfigs.POST_LOAD.add(() -> ((SellingBinConfig)config).validate(this.getPath()));
        return config;
    }
}

