/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.config;

import bigchadguys.sellingbin.config.FileConfig;
import bigchadguys.sellingbin.data.item.ItemPredicate;
import bigchadguys.sellingbin.data.item.PartialItem;
import bigchadguys.sellingbin.data.item.PartialStack;
import bigchadguys.sellingbin.data.nbt.PartialCompoundNbt;
import com.google.gson.annotations.Expose;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public class ItemGroupsConfig
extends FileConfig {
    @Expose
    private Map<class_2960, Set<ItemPredicate>> groups;

    @Override
    public String getPath() {
        return "item_groups";
    }

    public boolean hasGroup(class_2960 groupId) {
        return this.groups.containsKey(groupId);
    }

    public Set<ItemPredicate> getGroup(class_2960 groupId) {
        return this.groups.getOrDefault(groupId, new HashSet());
    }

    public boolean isInGroup(class_2960 groupId, PartialItem item, PartialCompoundNbt nbt) {
        for (ItemPredicate predicate : (Set)this.groups.getOrDefault(groupId, new HashSet())) {
            if (!predicate.test(item, nbt)) continue;
            return true;
        }
        return false;
    }

    public boolean isInGroup(class_2960 groupId, PartialStack stack) {
        return this.isInGroup(groupId, stack.getItem(), stack.getNbt());
    }

    @Override
    protected void reset() {
        this.groups = new LinkedHashMap<class_2960, Set<ItemPredicate>>();
    }
}

