/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.config;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.entity.EntityPredicate;
import bigchadguys.sellingbin.data.item.ItemPredicate;
import bigchadguys.sellingbin.data.tile.TilePredicate;
import bigchadguys.sellingbin.trade.Trade;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class Config {
    protected static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().setLenient().registerTypeHierarchyAdapter(Trade.class, Adapters.TRADE).registerTypeHierarchyAdapter(TilePredicate.class, (Object)Adapters.TILE_PREDICATE).registerTypeHierarchyAdapter(EntityPredicate.class, (Object)Adapters.ENTITY_PREDICATE).registerTypeHierarchyAdapter(ItemPredicate.class, (Object)Adapters.ITEM_PREDICATE).create();

    public abstract void write() throws IOException;

    public abstract <C extends Config> C read() throws IOException;

    protected abstract void reset();

    protected final void writeFile(Path path, Object file) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        FileWriter writer = new FileWriter(path.toFile());
        GSON.toJson(file, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    protected final <C> C readFile(Path path, Type type) throws FileNotFoundException {
        return (C)GSON.fromJson((Reader)new FileReader(path.toFile()), type);
    }
}

