/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin.block.entity;

import bigchadguys.sellingbin.SellingBinInventory;
import bigchadguys.sellingbin.block.BinMaterial;
import bigchadguys.sellingbin.block.BinMode;
import bigchadguys.sellingbin.block.SellingBinBlock;
import bigchadguys.sellingbin.block.entity.BaseBlockEntity;
import bigchadguys.sellingbin.init.ModBlocks;
import bigchadguys.sellingbin.init.ModWorldData;
import bigchadguys.sellingbin.screen.handler.SellingBinScreenHandler;
import bigchadguys.sellingbin.world.data.SellingBinData;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SellingBinBlockEntity
extends BaseBlockEntity
implements ExtendedMenuProvider {
    private final SellingBinInventory inventory;
    private long timeLeft;

    public SellingBinBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlocks.Entities.SELLING_BIN.get(), pos, state);
    }

    public SellingBinBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory = switch (this.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case BinMode.BLOCK_BOUND -> new SellingBinInventory(this, ((BinMaterial)((Object)state.method_11654(SellingBinBlock.MATERIAL))).getRows() * 9);
            case BinMode.PLAYER_BOUND -> null;
        };
    }

    public SellingBinInventory getInventory() {
        return this.inventory;
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(long updateTimeleft) {
        this.timeLeft = updateTimeleft;
        this.sendUpdatesToClient();
    }

    public BinMaterial getMaterial() {
        return (BinMaterial)((Object)this.method_11010().method_11654(SellingBinBlock.MATERIAL));
    }

    public BinMode getMode() {
        return (BinMode)((Object)this.method_11010().method_11654(SellingBinBlock.MODE));
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SellingBinBlockEntity entity) {
        if (world instanceof class_3218 && entity.getMode() == BinMode.BLOCK_BOUND) {
            if (entity.getTimeLeft() > entity.getMaterial().getUpdateDelayTicks()) {
                entity.setTimeLeft(entity.getMaterial().getUpdateDelayTicks());
            }
            if (entity.getTimeLeft() < 0L) {
                entity.getInventory().executeTrades();
                entity.setTimeLeft(entity.getMaterial().getUpdateDelayTicks());
            }
            entity.setTimeLeft(entity.getTimeLeft() - 1L);
        }
    }

    @Override
    public void writeNbt(class_2487 nbt, BaseBlockEntity.UpdateType type) {
        if (this.inventory != null && !this.inventory.method_5442()) {
            this.inventory.writeNbt().ifPresent(tag -> nbt.method_10566("inventory", (class_2520)tag));
        }
        if (this.timeLeft > 0L) {
            nbt.method_10544("timeLeft", this.timeLeft);
        }
    }

    @Override
    public void readNbt(class_2487 nbt, BaseBlockEntity.UpdateType type) {
        if (this.inventory != null) {
            this.inventory.readNbt(nbt.method_10562("inventory"));
        }
        this.timeLeft = nbt.method_10537("timeLeft");
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.selling_bin");
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        if (this.getMode() == BinMode.BLOCK_BOUND) {
            this.getInventory().setCapacity(this.getMaterial().getRows() * 9);
            return new SellingBinScreenHandler(syncId, playerInventory, (class_1263)this.getInventory(), this.method_11016(), this.getMaterial().getRows());
        }
        if (this.getMode() == BinMode.PLAYER_BOUND) {
            SellingBinData data = ModWorldData.SELLING_BIN.getGlobal(player.method_37908());
            SellingBinInventory inventory = data.getOrCreate(player, this.getMaterial()).getInventory();
            inventory.setCapacity(this.getMaterial().getRows() * 9);
            data.sendEntriesToClient((class_3222)player);
            return new SellingBinScreenHandler(syncId, playerInventory, (class_1263)inventory, this.method_11016(), this.getMaterial().getRows());
        }
        return null;
    }

    public void saveExtraData(class_2540 buf) {
        buf.method_10807(this.method_11016());
        buf.method_10804(this.getMaterial().getRows());
    }
}

