/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.sellingbin;

import bigchadguys.sellingbin.data.adapter.Adapters;
import bigchadguys.sellingbin.data.serializable.INbtSerializable;
import bigchadguys.sellingbin.init.ModConfigs;
import bigchadguys.sellingbin.trade.Trade;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class SellingBinInventory
implements class_1278,
INbtSerializable<class_2487> {
    private final class_2586 blockEntity;
    private class_2371<class_1799> inventory;
    private int[] availableSlots;

    public SellingBinInventory(class_2586 blockEntity, int slots) {
        this.blockEntity = blockEntity;
        this.setCapacity(slots);
        this.inventory = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
        this.availableSlots = new int[0];
    }

    public void setCapacity(int size) {
        this.availableSlots = IntStream.range(0, size).toArray();
        class_2371<class_1799> oldInventory = this.inventory;
        this.inventory = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        if (oldInventory != null) {
            for (int i = 0; i < Math.min(oldInventory.size(), this.inventory.size()); ++i) {
                this.inventory.set(i, (Object)((class_1799)oldInventory.get(i)));
            }
        }
        this.method_5431();
    }

    public void ensureCapacity(int size) {
        if (this.availableSlots.length >= size) {
            return;
        }
        this.setCapacity(size);
    }

    public int[] method_5494(class_2350 side) {
        return this.availableSlots;
    }

    public void method_5435(class_1657 player) {
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return this.blockEntity == null || class_1263.method_49105((class_2586)this.blockEntity, (class_1657)player);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_5431() {
        if (this.blockEntity != null) {
            this.blockEntity.method_5431();
        }
    }

    public void executeTrades() {
        ArrayList<class_1799> rewards = new ArrayList<class_1799>();
        for (Trade trade : ModConfigs.SELLING_BIN.getTrades()) {
            while (this.executeTrade(trade)) {
                trade.getOutput().generate().ifPresent(stack -> rewards.add(stack.method_7972()));
            }
        }
        rewards.removeIf(reward -> {
            int left = reward.method_7947();
            for (int slot : this.availableSlots) {
                class_1799 stack = this.method_5438(slot);
                if (left <= 0) break;
                if (!stack.method_7960() && !class_1799.method_31577((class_1799)stack, (class_1799)reward)) continue;
                int difference = Math.min(reward.method_7914() - stack.method_7947(), left);
                class_1799 copy = reward.method_7972();
                copy.method_7939(stack.method_7947() + difference);
                this.method_5447(slot, copy);
                left -= difference;
            }
            if (left <= 0) {
                return true;
            }
            reward.method_7939(left);
            return false;
        });
    }

    public boolean executeTrade(Trade trade) {
        int matchesLeft = trade.getInput().getCount();
        LinkedHashMap<Integer, class_1799> matches = new LinkedHashMap<Integer, class_1799>();
        for (int slot : this.availableSlots) {
            class_1799 stack = (class_1799)this.inventory.get(slot);
            if (!trade.getInput().getFilter().test(stack)) continue;
            int difference = Math.min(stack.method_7947(), matchesLeft);
            matches.put(slot, stack);
            if ((matchesLeft -= difference) <= 0) break;
        }
        if (matchesLeft == 0) {
            matchesLeft = trade.getInput().getCount();
            Object object = matches.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                int slot = (Integer)entry.getKey();
                class_1799 stack = (class_1799)entry.getValue();
                int difference = Math.min(stack.method_7947(), matchesLeft);
                stack.method_7934(difference);
                matchesLeft -= difference;
                this.method_5447(slot, stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        class_2499 slots = new class_2499();
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960()) continue;
            int slotIndex = i;
            Adapters.ITEM_STACK.writeNbt(stack).ifPresent(tag -> {
                Adapters.INT.writeNbt(slotIndex).ifPresent(tag2 -> ((class_2487)tag).method_10566("slot", tag2));
                slots.add(tag);
            });
        }
        nbt.method_10566("slots", (class_2520)slots);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 inventory = nbt.method_10554("slots", 10);
        this.inventory = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
        for (int i = 0; i < inventory.size(); ++i) {
            class_2487 entry = inventory.method_10602(i);
            Adapters.ITEM_STACK.readNbt((class_2520)entry).ifPresent(stack -> Adapters.INT.readNbt(entry.method_10580("slot")).ifPresent(slotIndex -> {
                this.ensureCapacity(slotIndex + 1);
                this.inventory.set(slotIndex.intValue(), stack);
            }));
        }
    }
}

