/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ListMultimap<class_2960, class_2960> getGroupIDsToStructureIDs(class_3218 world) {
        ArrayListMultimap groupIDsToStructureIDs = ArrayListMultimap.create();
        for (class_3195 structure : StructureUtils.getStructureRegistry(world)) {
            groupIDsToStructureIDs.put((Object)StructureUtils.getGroupForStructure(world, structure), (Object)StructureUtils.getIDForStructure(world, structure));
        }
        return groupIDsToStructureIDs;
    }

    public static Map<class_2960, class_2960> getStructureIDsToGroupIDs(class_3218 world) {
        HashMap<class_2960, class_2960> structureIDsToGroupIDs = new HashMap<class_2960, class_2960>();
        for (class_3195 structure : StructureUtils.getStructureRegistry(world)) {
            structureIDsToGroupIDs.put(StructureUtils.getIDForStructure(world, structure), StructureUtils.getGroupForStructure(world, structure));
        }
        return structureIDsToGroupIDs;
    }

    public static class_2960 getGroupForStructure(class_3218 world, class_3195 structure) {
        class_2378<class_7059> registry = StructureUtils.getStructureSetRegistry(world);
        for (class_7059 set : registry) {
            for (class_7059.class_7060 entry : set.comp_510()) {
                if (!((class_3195)entry.comp_512().comp_349()).equals(structure)) continue;
                return registry.method_10221((Object)set);
            }
        }
        return new class_2960("explorerscompass", "none");
    }

    public static class_2960 getIDForStructure(class_3218 world, class_3195 structure) {
        return StructureUtils.getStructureRegistry(world).method_10221((Object)structure);
    }

    public static class_3195 getStructureForID(class_3218 world, class_2960 id) {
        return (class_3195)StructureUtils.getStructureRegistry(world).method_10223(id);
    }

    public static class_6880<class_3195> getEntryForStructure(class_3218 world, class_3195 structure) {
        Optional optional = StructureUtils.getStructureRegistry(world).method_29113((Object)structure);
        if (optional.isPresent()) {
            return (class_6880)StructureUtils.getStructureRegistry(world).method_40264((class_5321)optional.get()).get();
        }
        return null;
    }

    public static List<class_2960> getAllowedStructureIDs(class_3218 world) {
        ArrayList<class_2960> structureIDs = new ArrayList<class_2960>();
        for (class_3195 structure : StructureUtils.getStructureRegistry(world)) {
            if (structure == null || StructureUtils.getIDForStructure(world, structure) == null || StructureUtils.getIDForStructure(world, structure).method_12836().isEmpty() || StructureUtils.getIDForStructure(world, structure).method_12832().isEmpty() || StructureUtils.structureIsBlacklisted(world, structure)) continue;
            structureIDs.add(StructureUtils.getIDForStructure(world, structure));
        }
        return structureIDs;
    }

    public static boolean structureIsBlacklisted(class_3218 world, class_3195 structure) {
        List<String> structureBlacklist = ExplorersCompassConfig.structureBlacklist;
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getIDForStructure(world, structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    public static List<class_2960> getGeneratingDimensionIDs(class_3218 serverWorld, class_3195 structure) {
        ArrayList<class_2960> dimensions = new ArrayList<class_2960>();
        for (class_3218 world : serverWorld.method_8503().method_3738()) {
            class_2794 chunkGenerator = world.method_14178().method_12129();
            Set biomeSet = chunkGenerator.method_12098().method_28443();
            if (structure.method_41607().method_40239().noneMatch(biomeSet::contains)) continue;
            dimensions.add(world.method_27983().method_29177());
        }
        if (structure == class_7151.field_37765 && dimensions.isEmpty()) {
            dimensions.add(new class_2960("minecraft:overworld"));
        }
        return dimensions;
    }

    public static ListMultimap<class_2960, class_2960> getGeneratingDimensionIDsForAllowedStructures(class_3218 serverWorld) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (class_2960 id : StructureUtils.getAllowedStructureIDs(serverWorld)) {
            class_3195 structure = StructureUtils.getStructureForID(serverWorld, id);
            dimensionsForAllowedStructures.putAll((Object)id, StructureUtils.getGeneratingDimensionIDs(serverWorld, structure));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getHorizontalDistanceToLocation(class_1657 player, int x, int z) {
        return StructureUtils.getHorizontalDistanceToLocation(player.method_24515(), x, z);
    }

    public static int getHorizontalDistanceToLocation(class_2338 startPos, int x, int z) {
        return (int)class_3532.method_15355((float)((float)startPos.method_10262((class_2382)new class_2338(x, startPos.method_10264(), z))));
    }

    @Environment(value=EnvType.CLIENT)
    public static String getStructureName(class_2960 id) {
        if (id == null) {
            return "";
        }
        String name = id.toString();
        if (ExplorersCompassConfig.translateStructureNames) {
            name = class_1074.method_4662((String)class_156.method_646((String)"structure", (class_2960)id), (Object[])new Object[0]);
        }
        if (name.equals(class_156.method_646((String)"structure", (class_2960)id)) || !ExplorersCompassConfig.translateStructureNames) {
            name = id.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @Environment(value=EnvType.CLIENT)
    public static String getStructureSource(class_2960 id) {
        if (id == null) {
            return "";
        }
        String registryEntry = id.toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = FabricLoader.getInstance().getModContainer(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getMetadata().getName();
        }
        return modid;
    }

    @Environment(value=EnvType.CLIENT)
    public static String structureDimensionsToString(List<class_2960> dimensions) {
        Object str = "";
        if (dimensions != null && dimensions.size() > 0) {
            str = StructureUtils.getDimensionName(dimensions.get(0));
            for (int i = 1; i < dimensions.size(); ++i) {
                str = (String)str + ", " + StructureUtils.getDimensionName(dimensions.get(i));
            }
        }
        return str;
    }

    @Environment(value=EnvType.CLIENT)
    private static String getDimensionName(class_2960 dimensionKey) {
        String name = class_1074.method_4662((String)class_156.method_646((String)"dimension", (class_2960)dimensionKey), (Object[])new Object[0]);
        if (name.equals(class_156.method_646((String)"dimension", (class_2960)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static class_2378<class_3195> getStructureRegistry(class_3218 world) {
        return world.method_30349().method_30530(class_7924.field_41246);
    }

    private static class_2378<class_7059> getStructureSetRegistry(class_3218 world) {
        return world.method_30349().method_30530(class_7924.field_41248);
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

