/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.incantationem.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import me.luligabi.incantationem.common.ModConfig;
import me.luligabi.incantationem.common.enchantment.EnchantmentRegistry;
import me.luligabi.incantationem.common.enchantment.curse.CurseRegistry;
import me.luligabi.incantationem.common.tag.TagRegistry;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1310;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Incantationem
implements ModInitializer {
    public static final String MOD_ID = "incantationem";
    public static final class_1310 SWINE = new class_1310();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Incantationem");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(String.format("%s%s%s.json", FabricLoader.getInstance().getConfigDir(), File.separator, "incantationem"));
    public static final ModConfig CONFIG = Incantationem.createConfig();

    public void onInitialize() {
        CurseRegistry.init();
        EnchantmentRegistry.init();
        TagRegistry.init();
    }

    public static class_2960 modId(String id) {
        return new class_2960(MOD_ID, id);
    }

    private static ModConfig createConfig() {
        ModConfig finalConfig;
        LOGGER.info("Trying to read config file...");
        try {
            if (CONFIG_FILE.createNewFile()) {
                LOGGER.info("No config file found, creating a new one...");
                Incantationem.writeConfig(GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)new ModConfig()))));
                finalConfig = new ModConfig();
                LOGGER.info("Successfully created default config file.");
            } else {
                LOGGER.info("A config file was found, loading it..");
                finalConfig = (ModConfig)GSON.fromJson(new String(Files.readAllBytes(CONFIG_FILE.toPath())), ModConfig.class);
                if (finalConfig == null) {
                    throw new NullPointerException("The config file was empty.");
                }
                LOGGER.info("Successfully loaded config file.");
            }
        }
        catch (Exception e) {
            LOGGER.error("There was an error creating/loading the config file!", (Throwable)e);
            finalConfig = new ModConfig();
            LOGGER.warn("Defaulting to original config.");
        }
        return finalConfig;
    }

    public static void saveConfig(ModConfig modConfig) {
        try {
            Incantationem.writeConfig(GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)modConfig))));
            LOGGER.info("Saved new config file.");
        }
        catch (Exception e) {
            LOGGER.error("There was an error saving the config file!", (Throwable)e);
        }
    }

    private static void writeConfig(String json) {
        try (PrintWriter printWriter = new PrintWriter(CONFIG_FILE);){
            printWriter.write(json);
            printWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }
}

