/*
 * Decompiled with CFR 0.152.
 */
package me.katanya04.minespawners.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigValue<T> {
    protected final String key;
    protected T value;
    protected final String tooltip;

    public ConfigValue(String key, T defValue, String tooltip) {
        this.key = key;
        this.value = defValue;
        this.tooltip = tooltip;
    }

    public String getKey() {
        return this.key;
    }

    abstract T jsonToValue(JsonElement var1);

    abstract JsonElement valueToJson();

    abstract T fromString(String var1);

    public T getValue() {
        return this.value;
    }

    public void setValue(@NotNull T value) {
        if (Objects.equals(value.getClass(), this.value.getClass())) {
            this.value = value;
        }
    }

    public void setValue(String value) {
        this.setValue(this.fromString(value));
    }

    public void setValueFromJson(@NotNull JsonObject json) {
        T newValue = this.jsonToValue(json.get(this.getKey()));
        this.setValue(newValue);
    }

    public void setValueToJson(@NotNull JsonObject json) {
        json.add(this.getKey(), this.valueToJson());
    }

    public String toString() {
        return this.getKey() + ": " + String.valueOf(this.value);
    }
}

