/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class UtilityTag {
    public static final class_2960 SILICA_TAG = UtilityTag.platformTag("silica_glass", "silica");
    public static final class_2960 GLASS_TAG = UtilityTag.platformTag("glass_blocks", "glass");
    public static final class_2960 GLASS_PANE_TAG = UtilityTag.platformTag("glass_panes");

    public static class_2960 getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink sink, class_3300 manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        class_2960 RLocLogs = new class_2960(resLocMOD + "_" + suffixTag);
        class_2960 RLocStems = new class_2960(resLocMOD + "_" + suffixAlt);
        class_2960 RLocFolders = new class_2960(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName());
        class_2960 RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (UtilityTag.doTagExistFor(RLocLogs, manager)) {
            return RLocLogs;
        }
        if (UtilityTag.doTagExistFor(RLocStems, manager)) {
            return RLocStems;
        }
        if (UtilityTag.doTagExistFor(RLocEC, manager)) {
            return RLocEC;
        }
        if (UtilityTag.doTagExistFor(RLocFolders, manager)) {
            return RLocFolders;
        }
        UtilityTag.createAndAddDefaultTags(RLocEC, sink, blockType, new class_2248[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(class_2960 resLoc, ResourceSink sink, BlockType blockType, class_2248 ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return UtilityTag.createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return UtilityTag.createAndAddCustomTags(resLoc, sink, blocks);
    }

    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_2248 ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)resLoc);
        for (class_2248 block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41254);
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_1792 ... items) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)resLoc);
        for (class_1792 item : items) {
            if (item == null) continue;
            tagBuilder.addEntry((Object)item);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameBlockTypeOrRegEx, String fromModId, String tagResLoc, boolean includeBlock, boolean includeItem, ResourceSink sink) {
        UtilityTag.addTagToAllBlocks(blocks, nameBlockTypeOrRegEx, fromModId, tagResLoc, includeBlock, includeItem, sink, null);
    }

    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(Map<T, B> blocks, String nameBlockTypeOrRegEx, String fromModId, String tagResLoc, boolean includeBlock, boolean includeItem, ResourceSink pack, @Nullable String regexBlockId) {
        if (PlatHelper.isModLoaded((String)fromModId) || fromModId.isEmpty()) {
            if (!((String)tagResLoc).contains(":")) {
                tagResLoc = fromModId + ":" + (String)tagResLoc;
            }
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)new class_2960((String)tagResLoc));
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType blockType = (BlockType)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                String blockPath = Utils.getID((class_2248)block).method_12832();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!blockType.getId().toString().matches(fromModId + ":" + nameBlockTypeOrRegEx) && !fromModId.isEmpty() || regexBlockId != null && !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, class_7924.field_41254);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, class_7924.field_41197);
                }
            }
        }
    }

    public static Pair<class_2960, Boolean> getATagId(String idTag, String idAlt, class_3300 manager) {
        class_2960 RLocId = new class_2960(idTag);
        class_2960 RLocIdAlt = new class_2960(idAlt);
        if (UtilityTag.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (UtilityTag.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(class_2960 resLoc, class_3300 manager) {
        boolean blockTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("blocks/"))).isPresent();
        boolean itemTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static class_2960 platformTag(String tagPath) {
        return UtilityTag.platformTag(tagPath, tagPath);
    }

    public static class_2960 platformTag(String fabric, String forge) {
        return PlatHelper.getPlatform().isFabric() ? UtilityTag.fabricTag(fabric) : UtilityTag.forgeTag(forge);
    }

    public static class_2960 fabricTag(String tagPath) {
        return new class_2960("c", tagPath);
    }

    public static class_2960 forgeTag(String tagPath) {
        return new class_2960("forge", tagPath);
    }
}

