/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.util.queue;

import de.siphalor.spiceoffabric.util.queue.FixedLengthIntFIFOQueue;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.annotations.NotNull;

public class FixedLengthIntFIFOQueueWithStats
implements FixedLengthIntFIFOQueue {
    private final FixedLengthIntFIFOQueue queue;
    private final Int2IntMap stats;

    public FixedLengthIntFIFOQueueWithStats(FixedLengthIntFIFOQueue queue) {
        this.queue = queue;
        this.stats = new Int2IntAVLTreeMap();
        this.rebuildStats();
    }

    private void rebuildStats() {
        this.stats.clear();
        this.queue.forEach(x -> this.stats.merge(x, 1, Integer::sum));
    }

    public Int2IntMap getStats() {
        return this.stats;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.stats.clear();
    }

    @Override
    public int get(int index) {
        return this.queue.get(index);
    }

    @Override
    public void enqueue(int x) {
        this.queue.enqueue(x);
        this.stats.merge(x, 1, Integer::sum);
    }

    @Override
    public Integer forceEnqueue(int x) {
        Integer old = this.queue.forceEnqueue(x);
        if (old != null) {
            this.decrementStat(old);
        }
        this.incrementStat(x);
        return old;
    }

    @Override
    public int dequeue() {
        int x = this.queue.dequeue();
        this.decrementStat(x);
        return x;
    }

    private void incrementStat(int x) {
        this.stats.merge(x, 1, Integer::sum);
    }

    private void decrementStat(int x) {
        int amount = this.stats.computeIfPresent(x, (k, v) -> v - 1);
        if (amount <= 0) {
            this.stats.remove(x);
        }
    }

    @Override
    public int getLength() {
        return this.queue.getLength();
    }

    @Override
    public void setLength(int newLength) {
        int oldLength = this.queue.getLength();
        this.queue.setLength(newLength);
        if (newLength < oldLength) {
            this.rebuildStats();
        }
    }

    @NotNull
    public IntIterator iterator() {
        return this.queue.iterator();
    }

    public void forEach(IntConsumer action) {
        this.queue.forEach(action);
    }
}

