/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.config;

import com.mojang.datafixers.util.Pair;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.shadow.net.objecthunter.exp4j.Expression;
import de.siphalor.spiceoffabric.shadow.net.objecthunter.exp4j.ExpressionBuilder;
import de.siphalor.spiceoffabric.shadow.net.objecthunter.exp4j.ValidationResult;
import de.siphalor.tweed4.config.constraints.AnnotationConstraint;
import de.siphalor.tweed4.config.constraints.Constraint;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExpressionConstraint
implements AnnotationConstraint<String> {
    private String[] variables;

    public void fromAnnotationParam(String param, Class<?> valueType) {
        this.variables = StringUtils.split((String)param, (char)',');
    }

    public Constraint.Result<String> apply(String value) {
        try {
            Expression expression = new ExpressionBuilder(value).functions(SOFConfig.customExpFunctions).variables(this.variables).build();
            ValidationResult result = expression.validate(false);
            if (!result.isValid()) {
                return new Constraint.Result(false, null, result.getErrors().stream().map(error -> Pair.of((Object)Constraint.Severity.ERROR, (Object)error)).toList());
            }
            if (value.contains("^")) {
                return new Constraint.Result(true, (Object)value, Collections.singletonList(Pair.of((Object)Constraint.Severity.WARN, (Object)"The ^ operator is deprecated in Spice of Fabric expressions, use the power() function instead")));
            }
            return new Constraint.Result(true, (Object)value, Collections.emptyList());
        }
        catch (IllegalArgumentException e) {
            return new Constraint.Result(false, null, List.of(Pair.of((Object)Constraint.Severity.ERROR, (Object)(e.getMessage() + "; in expression: " + value))));
        }
        catch (Exception e) {
            return new Constraint.Result(false, null, List.of(Pair.of((Object)Constraint.Severity.ERROR, (Object)("Invalid expression, got " + e.getClass().getSimpleName() + ": " + e.getMessage() + "; in expression: " + value))));
        }
    }

    public String getDescription() {
        return "Must be a valid expression";
    }
}

