/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.assembler;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.assembler.PieceContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.IMaxCountJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawSinglePoolElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawStructureAssembler {
    private final Settings settings;
    private final List<PieceEntry> pieces = new ArrayList<PieceEntry>();
    public Deque<PieceEntry> unprocessedPieceEntries = Queues.newArrayDeque();
    private final Map<String, Integer> pieceCounts = new HashMap<String, Integer>();
    private final Map<String, Integer> maxPieceCounts = new HashMap<String, Integer>();

    public JigsawStructureAssembler(Settings settings) {
        this.settings = settings;
    }

    public void assembleStructure(class_3790 startPiece, BoxOctree structureBounds) {
        PieceEntry startPieceEntry = new PieceEntry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)structureBounds), null, 0, null, null, null);
        this.pieces.add(startPieceEntry);
        this.unprocessedPieceEntries.addLast(startPieceEntry);
        while (!this.unprocessedPieceEntries.isEmpty()) {
            PieceEntry entry = this.unprocessedPieceEntries.removeFirst();
            this.addChildrenForPiece(entry);
        }
        this.applyModifications();
    }

    public void addAllPiecesToStructureBuilder(class_6626 structurePiecesBuilder) {
        this.pieces.forEach(pieceEntry -> structurePiecesBuilder.method_35462((class_3443)pieceEntry.getPiece()));
    }

    private void addChildrenForPiece(PieceEntry pieceEntry) {
        class_6880 fallbackPoolHolder;
        class_3790 piece = pieceEntry.getPiece();
        MutableObject parentOctree = new MutableObject();
        List pieceJigsawBlocks = piece.method_16644().method_16627(this.settings.structureTemplateManager, piece.method_16648(), piece.method_16888(), this.settings.rand);
        boolean generatedAtLeastOneChildPiece = false;
        for (class_3499.class_3501 jigsawBlockInfo : pieceJigsawBlocks) {
            class_5321<class_3785> poolKey = JigsawStructureAssembler.readPoolName(jigsawBlockInfo);
            Optional optionalPoolHolder = this.settings.poolRegistry.method_40264(poolKey);
            if (optionalPoolHolder.isEmpty()) {
                YungsApiCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)poolKey.method_29177());
                continue;
            }
            class_6880 targetPoolHolder = (class_6880)optionalPoolHolder.get();
            class_3785 targetPool = (class_3785)targetPoolHolder.comp_349();
            if (targetPool.method_16632() == 0 && !targetPoolHolder.method_40225(class_5468.field_26254)) {
                YungsApiCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)poolKey.method_29177());
                continue;
            }
            fallbackPoolHolder = ((class_3785)targetPoolHolder.comp_349()).method_46736();
            class_3785 fallbackPool = (class_3785)fallbackPoolHolder.comp_349();
            if (fallbackPool.method_16632() == 0 && !fallbackPoolHolder.method_40225(class_5468.field_26254)) {
                YungsApiCommon.LOGGER.warn("Empty or nonexistent fallback pool: {}", (Object)fallbackPoolHolder.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                continue;
            }
            PieceContext pieceContext = this.createPieceContextForJigsawBlock(jigsawBlockInfo, pieceEntry, (MutableObject<BoxOctree>)parentOctree);
            Optional<Object> newlyGeneratedPiece = Optional.empty();
            if (pieceEntry.getDepth() != this.settings.maxDepth) {
                pieceContext.candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)targetPool).getRawTemplates());
                newlyGeneratedPiece = this.chooseCandidateFromPool(pieceContext);
            }
            if (newlyGeneratedPiece.isEmpty()) {
                pieceContext.candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)fallbackPool).getRawTemplates());
                newlyGeneratedPiece = this.chooseCandidateFromPool(pieceContext);
            }
            if (!newlyGeneratedPiece.isPresent()) continue;
            generatedAtLeastOneChildPiece = true;
        }
        if (pieceEntry.getDeadendPool().isPresent() && !generatedAtLeastOneChildPiece && pieceJigsawBlocks.size() > 1) {
            class_2960 deadendPoolId = pieceEntry.getDeadendPool().get();
            Optional deadendPool = this.settings.poolRegistry.method_17966(deadendPoolId);
            if (deadendPool.isEmpty()) {
                YungsApiCommon.LOGGER.error("Unable to find deadend pool {} for element {}", (Object)deadendPoolId, (Object)piece.method_16644());
                return;
            }
            PieceEntry parentEntry = pieceEntry.getParentEntry();
            PieceContext newContext = pieceEntry.getSourcePieceContext().copy();
            newContext.candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)deadendPool.get()).getRawTemplates());
            class_238 pieceAabb = pieceEntry.getPieceAabb();
            if (parentEntry != null && pieceAabb != null) {
                IMaxCountJigsawPoolElement maxCountJigsawPoolElement;
                Object pieceName;
                parentEntry.getPiece().method_16645().remove(pieceEntry.getParentJunction());
                ((BoxOctree)pieceEntry.getBoxOctree().getValue()).removeBox(pieceAabb);
                this.pieces.remove(pieceEntry);
                fallbackPoolHolder = pieceEntry.getPiece().method_16644();
                if (fallbackPoolHolder instanceof YungJigsawPoolElement) {
                    YungJigsawPoolElement yungElement = (YungJigsawPoolElement)fallbackPoolHolder;
                    if (yungElement.maxCount.isPresent() && yungElement.name.isPresent() && this.pieceCounts.containsKey(yungElement.name.get())) {
                        pieceName = yungElement.name.get();
                        this.pieceCounts.put((String)pieceName, this.pieceCounts.get(pieceName) - 1);
                    }
                }
                if ((pieceName = pieceEntry.getPiece().method_16644()) instanceof IMaxCountJigsawPoolElement && this.pieceCounts.containsKey((maxCountJigsawPoolElement = (IMaxCountJigsawPoolElement)pieceName).getName())) {
                    pieceName = maxCountJigsawPoolElement.getName();
                    this.pieceCounts.put((String)pieceName, this.pieceCounts.get(pieceName) - 1);
                }
                this.chooseCandidateFromPool(newContext);
            }
        }
    }

    private PieceContext createPieceContextForJigsawBlock(class_3499.class_3501 jigsawBlockInfo, PieceEntry pieceEntry, MutableObject<BoxOctree> parentOctree) {
        class_3341 pieceBoundingBox = pieceEntry.getPiece().method_14935();
        MutableObject<BoxOctree> pieceOctree = pieceEntry.getBoxOctree();
        class_2350 direction = class_3748.method_26378((class_2680)jigsawBlockInfo.comp_1342());
        class_2338 jigsawBlockTargetPos = jigsawBlockInfo.comp_1341().method_10093(direction);
        boolean isTargetInsideCurrentPiece = pieceBoundingBox.method_14662((class_2382)jigsawBlockTargetPos);
        if (isTargetInsideCurrentPiece) {
            pieceOctree = parentOctree;
            if (parentOctree.getValue() == null) {
                parentOctree.setValue((Object)new BoxOctree(class_238.method_19316((class_3341)pieceBoundingBox)));
            }
        }
        return new PieceContext(null, jigsawBlockInfo, jigsawBlockTargetPos, pieceBoundingBox.method_35416(), jigsawBlockInfo.comp_1341(), pieceOctree, pieceEntry, pieceEntry.getDepth());
    }

    private Optional<class_3784> chooseCandidateFromPool(PieceContext context) {
        ObjectArrayList<Pair<class_3784, Integer>> candidatePoolElements = context.candidatePoolElements;
        class_3790 piece = context.pieceEntry.getPiece();
        boolean isPieceRigid = piece.method_16644().method_16624() == class_3785.class_3786.field_16687;
        int jigsawBlockRelativeY = context.jigsawBlockPos.method_10264() - context.pieceMinY;
        int surfaceHeight = -1;
        class_156.method_43028(candidatePoolElements, (class_5819)this.settings.rand);
        int totalWeightSum = candidatePoolElements.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
        while (candidatePoolElements.size() > 0 && totalWeightSum > 0) {
            YungJigsawPoolElement yungElement;
            Pair chosenPoolElementPair = null;
            for (Pair candidatePiecePair : candidatePoolElements) {
                YungJigsawPoolElement yungElement2;
                class_3784 candidatePiece = (class_3784)candidatePiecePair.getFirst();
                if (!(candidatePiece instanceof YungJigsawPoolElement) || !(yungElement2 = (YungJigsawPoolElement)candidatePiece).isPriorityPiece()) continue;
                chosenPoolElementPair = candidatePiecePair;
                break;
            }
            if (chosenPoolElementPair == null) {
                Pair candidatePiecePair;
                int chosenWeight = this.settings.rand.method_43048(totalWeightSum) + 1;
                candidatePiecePair = candidatePoolElements.iterator();
                while (candidatePiecePair.hasNext()) {
                    Pair candidate = (Pair)candidatePiecePair.next();
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPoolElementPair = candidate;
                    break;
                }
            }
            class_3784 chosenPoolElement = (class_3784)chosenPoolElementPair.getFirst();
            int chosenPieceWeight = (Integer)chosenPoolElementPair.getSecond();
            if (chosenPoolElement == class_3777.field_16663) {
                return Optional.empty();
            }
            if (chosenPoolElement instanceof YungJigsawPoolElement) {
                yungElement = (YungJigsawPoolElement)chosenPoolElement;
                if (yungElement.maxCount.isPresent()) {
                    int pieceMaxCount = yungElement.maxCount.get();
                    if (yungElement.name.isEmpty()) {
                        YungsApiCommon.LOGGER.error("Found YUNG Jigsaw piece with max_count={} missing \"name\" property.", (Object)pieceMaxCount);
                        YungsApiCommon.LOGGER.error("Max count pieces must be named in order to work properly!");
                        YungsApiCommon.LOGGER.error("Ignoring max_count for this piece...");
                    } else {
                        String pieceName = yungElement.name.get();
                        if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != pieceMaxCount) {
                            YungsApiCommon.LOGGER.error("YUNG Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)pieceMaxCount, (Object)this.maxPieceCounts.get(pieceName));
                            YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                            YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)pieceMaxCount);
                        }
                        this.maxPieceCounts.put(pieceName, pieceMaxCount);
                        if (this.pieceCounts.getOrDefault(pieceName, 0) >= pieceMaxCount) {
                            totalWeightSum -= chosenPieceWeight;
                            candidatePoolElements.remove((Object)chosenPoolElementPair);
                            continue;
                        }
                    }
                }
            }
            if (chosenPoolElement instanceof IMaxCountJigsawPoolElement) {
                String pieceName = ((IMaxCountJigsawPoolElement)chosenPoolElement).getName();
                int maxCount = ((IMaxCountJigsawPoolElement)chosenPoolElement).getMaxCount();
                if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != maxCount) {
                    YungsApiCommon.LOGGER.error("Max Count Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)maxCount, (Object)this.maxPieceCounts.get(pieceName));
                    YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                    YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)maxCount);
                }
                this.maxPieceCounts.put(pieceName, maxCount);
                if (this.pieceCounts.getOrDefault(pieceName, 0) >= maxCount) {
                    totalWeightSum -= ((Integer)chosenPoolElementPair.getSecond()).intValue();
                    candidatePoolElements.remove((Object)chosenPoolElementPair);
                    continue;
                }
            }
            if (chosenPoolElement instanceof YungJigsawPoolElement && !(yungElement = (YungJigsawPoolElement)chosenPoolElement).isAtValidDepth(context.depth)) {
                totalWeightSum -= chosenPieceWeight;
                candidatePoolElements.remove((Object)chosenPoolElementPair);
                continue;
            }
            for (class_2470 rotation : class_2470.method_16547((class_5819)this.settings.rand)) {
                List candidateJigsawBlocks = chosenPoolElement.method_16627(this.settings.structureTemplateManager, class_2338.field_10980, rotation, this.settings.rand);
                class_3341 tempCandidateBoundingBox = chosenPoolElement.method_16628(this.settings.structureTemplateManager, class_2338.field_10980, rotation);
                int candidateHeightAdjustments = 0;
                if (this.settings.useExpansionHack && tempCandidateBoundingBox.method_14660() <= 16) {
                    candidateHeightAdjustments = candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.method_14662((class_2382)pieceCandidateJigsawBlock.comp_1341().method_10093(class_3748.method_26378((class_2680)pieceCandidateJigsawBlock.comp_1342())))) {
                            return 0;
                        }
                        class_5321<class_3785> candidateTargetPoolKey = JigsawStructureAssembler.readPoolName(pieceCandidateJigsawBlock);
                        Optional candidateTargetPool = this.settings.poolRegistry.method_40264(candidateTargetPoolKey);
                        Optional<class_6880> candidateFallbackPool = candidateTargetPool.map(poolHolder -> ((class_3785)poolHolder.comp_349()).method_46736());
                        int candidateMaxSize = candidateTargetPool.map(poolHolder -> ((class_3785)poolHolder.comp_349()).method_19309(this.settings.structureTemplateManager)).orElse(0);
                        int candidateFallbackMaxSize = candidateFallbackPool.map(poolHolder -> ((class_3785)poolHolder.comp_349()).method_19309(this.settings.structureTemplateManager)).orElse(0);
                        return Math.max(candidateMaxSize, candidateFallbackMaxSize);
                    }).max().orElse(0);
                }
                for (class_3499.class_3501 candidateJigsawBlock : candidateJigsawBlocks) {
                    StructureContext ctx;
                    YungJigsawPoolElement yungElement3;
                    int candidateJigsawBlockY;
                    int adjustedCandidatePieceMinY;
                    if (!class_3748.method_16546((class_3499.class_3501)context.jigsawBlock, (class_3499.class_3501)candidateJigsawBlock)) continue;
                    class_2338 candidateJigsawBlockPos = candidateJigsawBlock.comp_1341();
                    class_2338 candidateJigsawBlockRelativePos = context.jigsawBlockTargetPos.method_10059((class_2382)candidateJigsawBlockPos);
                    class_3341 rotatedCandidateBoundingBox = chosenPoolElement.method_16628(this.settings.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                    class_3785.class_3786 candidateProjection = chosenPoolElement.method_16624();
                    boolean isCandidateRigid = candidateProjection == class_3785.class_3786.field_16687;
                    int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.method_10264();
                    int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + class_3748.method_26378((class_2680)context.jigsawBlock.comp_1342()).method_10164();
                    if (isPieceRigid && isCandidateRigid) {
                        adjustedCandidatePieceMinY = context.pieceMinY + candidateJigsawYOffsetNeeded;
                    } else {
                        if (surfaceHeight == -1) {
                            surfaceHeight = this.settings.chunkGenerator.method_20402(context.jigsawBlockPos.method_10263(), context.jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, this.settings.levelHeightAccessor, this.settings.randomState);
                        }
                        adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                    }
                    int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - rotatedCandidateBoundingBox.method_35416();
                    class_3341 adjustedCandidateBoundingBox = rotatedCandidateBoundingBox.method_19311(0, candidatePieceYOffsetNeeded, 0);
                    class_2338 adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.method_10069(0, candidatePieceYOffsetNeeded, 0);
                    if (candidateHeightAdjustments > 0) {
                        int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.method_35419() - adjustedCandidateBoundingBox.method_35416());
                        ((BoundingBoxAccessor)adjustedCandidateBoundingBox).setMaxY(adjustedCandidateBoundingBox.method_35416() + k2);
                    }
                    if (this.settings.maxY.isPresent() && adjustedCandidateBoundingBox.method_35419() > this.settings.maxY.get() || this.settings.minY.isPresent() && adjustedCandidateBoundingBox.method_35416() < this.settings.minY.get()) continue;
                    class_238 aabb = class_238.method_19316((class_3341)adjustedCandidateBoundingBox);
                    class_238 aabbDeflated = aabb.method_1011(0.25);
                    boolean pieceIgnoresBounds = false;
                    if (chosenPoolElement instanceof YungJigsawPoolElement) {
                        YungJigsawPoolElement yungElement4 = (YungJigsawPoolElement)chosenPoolElement;
                        pieceIgnoresBounds = yungElement4.ignoresBounds();
                    }
                    if (!pieceIgnoresBounds) {
                        boolean pieceIntersectsExistingPieces = ((BoxOctree)context.boxOctree.getValue()).intersectsAnyBox(aabbDeflated);
                        boolean pieceIsContainedWithinStructureBoundaries = ((BoxOctree)context.boxOctree.getValue()).boundaryContains(aabbDeflated);
                        if (pieceIntersectsExistingPieces || !pieceIsContainedWithinStructureBoundaries) continue;
                    }
                    int newPieceGroundLevelDelta = piece.method_16646();
                    int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : chosenPoolElement.method_19308();
                    if (isPieceRigid) {
                        candidateJigsawBlockY = context.pieceMinY + jigsawBlockRelativeY;
                    } else if (isCandidateRigid) {
                        candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                    } else {
                        if (surfaceHeight == -1) {
                            surfaceHeight = this.settings.chunkGenerator.method_20402(context.jigsawBlockPos.method_10263(), context.jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, this.settings.levelHeightAccessor, this.settings.randomState);
                        }
                        candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                    }
                    class_3790 newPiece = new class_3790(this.settings.structureTemplateManager, chosenPoolElement, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                    class_3780 newJunctionOnParent = new class_3780(context.jigsawBlockTargetPos.method_10263(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, context.jigsawBlockTargetPos.method_10260(), candidateJigsawYOffsetNeeded, candidateProjection);
                    PieceEntry newPieceEntry = new PieceEntry(newPiece, context.boxOctree, aabb, context.depth + 1, context.pieceEntry, context.copy(), newJunctionOnParent);
                    if (chosenPoolElement instanceof YungJigsawPoolElement && !(yungElement3 = (YungJigsawPoolElement)chosenPoolElement).passesConditions(ctx = new StructureContext.Builder().structureTemplateManager(this.settings.structureTemplateManager).pieces(this.pieces).pieceEntry(newPieceEntry).pos(adjustedCandidateJigsawBlockRelativePos).rotation(rotation).pieceMinY(adjustedCandidateBoundingBox.method_35416()).pieceMaxY(adjustedCandidateBoundingBox.method_35419()).depth(context.depth + 1).random(this.settings.rand).build())) continue;
                    piece.method_16647(newJunctionOnParent);
                    newPiece.method_16647(new class_3780(context.jigsawBlockPos.method_10263(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, context.jigsawBlockPos.method_10260(), -candidateJigsawYOffsetNeeded, piece.method_16644().method_16624()));
                    ((BoxOctree)context.boxOctree.getValue()).addBox(aabb);
                    this.pieces.add(newPieceEntry);
                    context.pieceEntry.addChildEntry(newPieceEntry);
                    if (context.depth + 1 <= this.settings.maxDepth) {
                        this.unprocessedPieceEntries.addLast(newPieceEntry);
                    }
                    if (chosenPoolElement instanceof YungJigsawPoolElement) {
                        yungElement3 = (YungJigsawPoolElement)chosenPoolElement;
                        if (yungElement3.maxCount.isPresent()) {
                            if (yungElement3.name.isEmpty()) {
                                return Optional.of(chosenPoolElement);
                            }
                            String pieceName = yungElement3.name.get();
                            this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                        }
                    }
                    if (chosenPoolElement instanceof IMaxCountJigsawPoolElement) {
                        String pieceName = ((IMaxCountJigsawPoolElement)chosenPoolElement).getName();
                        this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                    }
                    return Optional.of(chosenPoolElement);
                }
            }
            totalWeightSum -= chosenPieceWeight;
            candidatePoolElements.remove((Object)chosenPoolElementPair);
        }
        return Optional.empty();
    }

    private void applyModifications() {
        for (PieceEntry pieceEntry : this.pieces) {
            YungJigsawSinglePoolElement yungElement;
            class_3784 class_37842 = pieceEntry.getPiece().method_16644();
            if (!(class_37842 instanceof YungJigsawSinglePoolElement) || !(yungElement = (YungJigsawSinglePoolElement)class_37842).hasModifiers()) continue;
            class_3790 piece = pieceEntry.getPiece();
            StructureContext structureContext = new StructureContext.Builder().pos(piece.method_16648()).rotation(piece.method_16888()).depth(pieceEntry.getDepth()).structureTemplateManager(this.settings.structureTemplateManager).pieceEntry(pieceEntry).pieces(this.pieces).pieceMaxY(piece.method_14935().method_35419()).pieceMinY(piece.method_14935().method_35416()).random(this.settings.rand).build();
            yungElement.modifiers.forEach(modifier -> modifier.apply(structureContext));
        }
        List<PieceEntry> delayedEntries = this.pieces.stream().filter(PieceEntry::isDelayGeneration).toList();
        this.pieces.removeAll(delayedEntries);
        this.pieces.addAll(delayedEntries);
    }

    private static class_5321<class_3785> readPoolName(class_3499.class_3501 jigsawBlockInfo) {
        return class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)new class_2960(jigsawBlockInfo.comp_1343().method_10558("pool")));
    }

    public static class Settings {
        private class_2378<class_3785> poolRegistry;
        private int maxDepth;
        private class_2794 chunkGenerator;
        private class_3485 structureTemplateManager;
        private class_5539 levelHeightAccessor;
        private class_5819 rand;
        private boolean useExpansionHack;
        public class_7138 randomState;
        private Optional<Integer> maxY;
        private Optional<Integer> minY;

        public Settings poolRegistry(class_2378<class_3785> poolRegistry) {
            this.poolRegistry = poolRegistry;
            return this;
        }

        public Settings maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Settings chunkGenerator(class_2794 chunkGenerator) {
            this.chunkGenerator = chunkGenerator;
            return this;
        }

        public Settings structureTemplateManager(class_3485 structureTemplateManager) {
            this.structureTemplateManager = structureTemplateManager;
            return this;
        }

        public Settings randomState(class_7138 randomState) {
            this.randomState = randomState;
            return this;
        }

        public Settings rand(class_5819 rand) {
            this.rand = rand;
            return this;
        }

        public Settings useExpansionHack(boolean useExpansionHack) {
            this.useExpansionHack = useExpansionHack;
            return this;
        }

        public Settings levelHeightAccessor(class_5539 levelHeightAccessor) {
            this.levelHeightAccessor = levelHeightAccessor;
            return this;
        }

        public Settings maxY(Optional<Integer> maxY) {
            this.maxY = maxY;
            return this;
        }

        public Settings minY(Optional<Integer> minY) {
            this.minY = minY;
            return this;
        }
    }
}

