/*
 * Decompiled with CFR 0.152.
 */
package net.kaikk.mc.serverredirect.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_412;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerRedirect
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"serverredirect");
    public static final Pattern ADDRESS_PREVALIDATOR = Pattern.compile("^[A-Za-z0-9-_.:]+$");
    protected static final Set<UUID> players = Collections.synchronizedSet(new HashSet());
    public static final class_2960 redirectChannelIdentifier = new class_2960("srvredirect", "red");
    public static final class_2960 fallbackChannelIdentifier = new class_2960("srvredirect", "fal");
    public static final class_2960 announceChannelIdentifier = new class_2960("srvredirect", "ann");
    @Environment(value=EnvType.CLIENT)
    public static volatile String fallbackServerAddress;
    @Environment(value=EnvType.CLIENT)
    public static boolean connected;

    public void onInitialize() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)redirectChannelIdentifier, (c, h, b, rs) -> {
                try {
                    String addr = b.getCharSequence(1, b.capacity() - 1, StandardCharsets.UTF_8).toString();
                    if (ADDRESS_PREVALIDATOR.matcher(addr).matches()) {
                        c.execute(() -> {
                            try {
                                ServerRedirect.redirect(addr);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            ClientPlayNetworking.registerGlobalReceiver((class_2960)fallbackChannelIdentifier, (c, h, b, rs) -> {
                try {
                    String addr = b.getCharSequence(1, b.capacity() - 1, StandardCharsets.UTF_8).toString();
                    if (ADDRESS_PREVALIDATOR.matcher(addr).matches()) {
                        if (((ClientFallbackEvent)ClientFallbackEvent.EVENT.invoker()).fallback(addr) != class_1269.field_5812) {
                            return;
                        }
                        fallbackServerAddress = addr;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            ClientTickEvents.START_CLIENT_TICK.register(c -> {
                try {
                    if (connected != (c.field_1687 != null)) {
                        boolean bl = connected = c.field_1687 != null;
                        if (connected) {
                            ClientPlayNetworking.send((class_2960)announceChannelIdentifier, (class_2540)PacketByteBufs.empty());
                        }
                    } else if (fallbackServerAddress != null) {
                        if (c.field_1755 instanceof class_419) {
                            String addr = fallbackServerAddress;
                            fallbackServerAddress = null;
                            ServerRedirect.redirect(addr);
                        } else if (c.field_1755 instanceof class_442 || c.field_1755 instanceof class_500) {
                            fallbackServerAddress = null;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            try {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"redirect").requires(cs -> cs.method_9259(2))).redirect((CommandNode)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"serverredirect").requires(cs -> cs.method_9259(2))).then(this.commandAddress(ServerRedirect::sendTo)))));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fallback").requires(cs -> cs.method_9259(2))).redirect((CommandNode)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fallbackserver").requires(cs -> cs.method_9259(2))).then(this.commandAddress(ServerRedirect::sendFallbackTo)))));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ifplayercanredirect").requires(cs -> cs.method_9259(2))).then(this.commandIfPlayerRedirect(false)));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ifplayercannotredirect").requires(cs -> cs.method_9259(2))).then(this.commandIfPlayerRedirect(true)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, srv) -> {
            try {
                players.remove(handler.field_14140.method_5667());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)announceChannelIdentifier, (srv, player, handler, buf, response) -> {
            try {
                players.add(player.method_5667());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private ArgumentBuilder<class_2168, ?> commandAddress(BiConsumer<class_3222, String> consumer) {
        return class_2170.method_9244((String)"Player(s)", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"Server Address", (ArgumentType)StringArgumentType.greedyString()).executes(cs -> {
            try {
                String addr = (String)cs.getArgument("Server Address", String.class);
                if (!ADDRESS_PREVALIDATOR.matcher(addr).matches()) {
                    ((class_2168)cs.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Server Address"));
                    return 0;
                }
                ((class_2300)cs.getArgument("Player(s)", class_2300.class)).method_9813((class_2168)cs.getSource()).forEach(p -> {
                    try {
                        consumer.accept((class_3222)p, addr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    private ArgumentBuilder<class_2168, ?> commandIfPlayerRedirect(boolean not) {
        return class_2170.method_9244((String)"Player(s)", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"Command...", (ArgumentType)StringArgumentType.greedyString()).executes(cs -> {
            try {
                String command = (String)cs.getArgument("Command...", String.class);
                ((class_2300)cs.getArgument("Player(s)", class_2300.class)).method_9813((class_2168)cs.getSource()).forEach(p -> {
                    try {
                        if (ServerRedirect.isUsingServerRedirect(p) != not) {
                            ((class_2168)cs.getSource()).method_9225().method_8503().method_3734().method_44252((class_2168)cs.getSource(), command.replace("%PlayerName", p.method_7334().getName()).replace("%PlayerId", p.method_5845()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    @Environment(value=EnvType.CLIENT)
    public static void redirect(String serverAddress) {
        if (!class_310.method_1551().method_18854()) {
            throw new IllegalStateException("Not in the main thread");
        }
        if (((ClientRedirectEvent)ClientRedirectEvent.EVENT.invoker()).redirect(serverAddress) != class_1269.field_5812) {
            return;
        }
        LOGGER.info("Connecting to " + serverAddress);
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            mc.field_1687.method_8525();
        }
        mc.method_18099();
        mc.method_1507((class_437)new class_500((class_437)new class_442()));
        class_412.method_36877((class_437)mc.field_1755, (class_310)mc, (class_639)class_639.method_2950((String)serverAddress), (class_642)new class_642(serverAddress, serverAddress, false), (boolean)false);
    }

    public static boolean sendTo(class_3222 player, String serverAddress) {
        if (((PlayerRedirectEvent)PlayerRedirectEvent.EVENT.invoker()).redirect(player, serverAddress) != class_1269.field_5812) {
            return false;
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)redirectChannelIdentifier, (class_2540)ServerRedirect.serverAddressPacketByteBuf(serverAddress));
        return true;
    }

    public static void sendToAll(MinecraftServer server, String serverAddress) {
        class_2540 buf = ServerRedirect.serverAddressPacketByteBuf(serverAddress);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            if (((PlayerRedirectEvent)PlayerRedirectEvent.EVENT.invoker()).redirect(player, serverAddress) != class_1269.field_5812) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)redirectChannelIdentifier, (class_2540)buf);
        }
    }

    public static boolean sendFallbackTo(class_3222 player, String serverAddress) {
        if (((PlayerFallbackEvent)PlayerFallbackEvent.EVENT.invoker()).fallback(player, serverAddress) != class_1269.field_5812) {
            return false;
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)fallbackChannelIdentifier, (class_2540)ServerRedirect.serverAddressPacketByteBuf(serverAddress));
        return true;
    }

    public static void sendFallbackToAll(MinecraftServer server, String serverAddress) {
        class_2540 buf = ServerRedirect.serverAddressPacketByteBuf(serverAddress);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            if (((PlayerFallbackEvent)PlayerFallbackEvent.EVENT.invoker()).fallback(player, serverAddress) != class_1269.field_5812) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)fallbackChannelIdentifier, (class_2540)buf);
        }
    }

    private static class_2540 serverAddressPacketByteBuf(String address) {
        byte[] addressBytes = address.getBytes(StandardCharsets.UTF_8);
        class_2540 buf = PacketByteBufs.create();
        buf.writeByte(0);
        buf.writeBytes(addressBytes);
        return buf;
    }

    public static boolean isUsingServerRedirect(class_3222 player) {
        return ServerRedirect.isUsingServerRedirect(player.method_5667());
    }

    public static boolean isUsingServerRedirect(UUID playerId) {
        return players.contains(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachPlayerUsingServerRedirect(Consumer<UUID> consumer) {
        Set<UUID> set = players;
        synchronized (set) {
            for (UUID playerId : players) {
                consumer.accept(playerId);
            }
        }
    }

    public static Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(new HashSet<UUID>(players));
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ClientRedirectEvent {
        public static final Event<ClientRedirectEvent> EVENT = EventFactory.createArrayBacked(ClientRedirectEvent.class, listeners -> address -> {
            for (ClientRedirectEvent listener : listeners) {
                class_1269 result = listener.redirect(address);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            return class_1269.field_5812;
        });

        public class_1269 redirect(String var1);
    }

    public static interface PlayerRedirectEvent {
        public static final Event<PlayerRedirectEvent> EVENT = EventFactory.createArrayBacked(PlayerRedirectEvent.class, listeners -> (player, address) -> {
            for (PlayerRedirectEvent listener : listeners) {
                class_1269 result = listener.redirect(player, address);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            return class_1269.field_5812;
        });

        public class_1269 redirect(class_3222 var1, String var2);
    }

    public static interface PlayerFallbackEvent {
        public static final Event<PlayerFallbackEvent> EVENT = EventFactory.createArrayBacked(PlayerFallbackEvent.class, listeners -> (player, address) -> {
            for (PlayerFallbackEvent listener : listeners) {
                class_1269 result = listener.fallback(player, address);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            return class_1269.field_5812;
        });

        public class_1269 fallback(class_3222 var1, String var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ClientFallbackEvent {
        public static final Event<ClientFallbackEvent> EVENT = EventFactory.createArrayBacked(ClientFallbackEvent.class, listeners -> address -> {
            for (ClientFallbackEvent listener : listeners) {
                class_1269 result = listener.fallback(address);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            return class_1269.field_5812;
        });

        public class_1269 fallback(String var1);
    }
}

