/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlock;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.registry.fabric.CRBlockEntitiesImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FuelTankItem
extends class_1747 {
    @ApiStatus.Internal
    public static boolean IS_PLACING_NBT = false;

    public FuelTankItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    @NotNull
    public class_1269 method_7712(@NotNull class_1750 ctx) {
        IS_PLACING_NBT = FuelTankItem.checkPlacingNbt(ctx);
        class_1269 initialResult = super.method_7712(ctx);
        IS_PLACING_NBT = false;
        if (!initialResult.method_23665()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean method_7710(@NotNull class_2338 blockPos, class_1937 level, class_1657 player, @NotNull class_1799 itemStack, @NotNull class_2680 blockState) {
        MinecraftServer minecraftserver = level.method_8503();
        if (minecraftserver == null) {
            return false;
        }
        class_2487 nbt = itemStack.method_7941("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid;
            nbt.method_10551("Luminosity");
            nbt.method_10551("Size");
            nbt.method_10551("Height");
            nbt.method_10551("Controller");
            nbt.method_10551("LastKnownPos");
            if (nbt.method_10545("TankContent") && !(fluid = FluidStack.loadFluidStackFromNBT((class_2487)nbt.method_10562("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(FuelTankBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.method_10566("TankContent", (class_2520)fluid.writeToNBT(new class_2487()));
            }
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(class_1750 ctx) {
        class_2680 blockState;
        class_2338 offsetPos;
        int zOffset;
        int xOffset;
        class_2338 startPos;
        class_2338 pos;
        class_2338 placedOnPos;
        class_1657 player = ctx.method_8036();
        if (player == null) {
            return;
        }
        if (player.method_5715()) {
            return;
        }
        class_2350 face = ctx.method_8038();
        if (!face.method_10166().method_10178()) {
            return;
        }
        class_1799 stack = ctx.method_8041();
        class_1937 world = ctx.method_8045();
        class_2680 placedOnState = world.method_8320(placedOnPos = (pos = ctx.method_8037()).method_10093(face.method_10153()));
        if (!FuelTankBlock.isTank(placedOnState)) {
            return;
        }
        FuelTankBlockEntity tankAt = (FuelTankBlockEntity)ConnectivityHandler.partAt((class_2591)((class_2591)CRBlockEntitiesImpl.FUEL_TANK.get()), (class_1922)world, (class_2338)placedOnPos);
        if (tankAt == null) {
            return;
        }
        FuelTankBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.width;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        class_2338 class_23382 = startPos = face == class_2350.field_11033 ? controllerBE.method_11016().method_10074() : controllerBE.method_11016().method_10086(controllerBE.height);
        if (startPos.method_10264() != pos.method_10264()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.method_10069(xOffset, 0, zOffset);
                blockState = world.method_8320(offsetPos);
                if (FuelTankBlock.isTank(blockState)) continue;
                if (!blockState.method_45474()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.method_7337() && stack.method_7947() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.method_10069(xOffset, 0, zOffset);
                blockState = world.method_8320(offsetPos);
                if (FuelTankBlock.isTank(blockState)) continue;
                class_1750 context = class_1750.method_16355((class_1750)ctx, (class_2338)offsetPos, (class_2350)face);
                player.getCustomData().method_10556("SilenceTankSound", true);
                IS_PLACING_NBT = FuelTankItem.checkPlacingNbt(context);
                super.method_7712(context);
                IS_PLACING_NBT = false;
                player.getCustomData().method_10577("SilenceTankSound");
            }
        }
    }

    public static boolean checkPlacingNbt(class_1750 ctx) {
        class_1799 item = ctx.method_8041();
        return class_1747.method_38072((class_1799)item) != null;
    }
}

