/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.psi;

import com.railwayteam.railways.mixin.AccessorCarriageContraption;
import com.railwayteam.railways.mixin_interfaces.IContraptionFuel;
import com.railwayteam.railways.mixin_interfaces.IFuelInventory;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.fabric.ListeningStorageView;
import com.simibubi.create.foundation.utility.fabric.ProcessingIterator;
import io.github.fabricators_of_create.porting_lib.transfer.WrappedStorage;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PortableFuelInterfaceBlockEntity
extends PortableStorageInterfaceBlockEntity
implements SidedStorageBlockEntity {
    protected InterfaceFluidHandler capability = this.createEmptyHandler();

    public PortableFuelInterfaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        CombinedTankWrapper ctw = ((IContraptionFuel)contraption).railways$getSharedFuelTanks();
        if (contraption instanceof CarriageContraption) {
            CarriageContraption carriageContraption = (CarriageContraption)contraption;
            MountedStorageManager storageProxy = ((AccessorCarriageContraption)carriageContraption).railways$getStorageProxy();
            ctw = ((IFuelInventory)storageProxy).railways$getFuelFluids();
        }
        this.capability.setWrapped((Storage<FluidVariant>)ctw);
        super.startTransferringTo(contraption, distance);
    }

    protected void invalidateCapability() {
        this.capability.setWrapped((Storage<FluidVariant>)Storage.empty());
    }

    protected void stopTransferring() {
        this.capability.setWrapped((Storage<FluidVariant>)Storage.empty());
        super.stopTransferring();
    }

    private InterfaceFluidHandler createEmptyHandler() {
        return new InterfaceFluidHandler((Storage<FluidVariant>)Storage.empty());
    }

    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        return this.capability;
    }

    boolean isConnected() {
        int timeUnit = this.getTransferTimeout();
        return this.transferTimer >= 4 && this.transferTimer <= timeUnit + 4;
    }

    public class InterfaceFluidHandler
    extends WrappedStorage<FluidVariant> {
        public InterfaceFluidHandler(Storage<FluidVariant> wrapped) {
            super(wrapped);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableFuelInterfaceBlockEntity.this.isConnected()) {
                return 0L;
            }
            long fill = this.wrapped.insert((Object)resource, maxAmount, transaction);
            if (fill > 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return fill;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableFuelInterfaceBlockEntity.this.canTransfer()) {
                return 0L;
            }
            long drain = this.wrapped.extract((Object)resource, maxAmount, transaction);
            if (drain != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return drain;
        }

        @Nullable
        public StorageView<FluidVariant> exactView(FluidVariant resource) {
            return this.listen(super.exactView((Object)resource));
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return new ProcessingIterator(super.iterator(), this::listen);
        }

        public <T> StorageView<T> listen(StorageView<T> view) {
            return new ListeningStorageView(view, this::keepAlive);
        }

        public void keepAlive() {
            PortableFuelInterfaceBlockEntity.this.onContentTransferred();
        }

        private void setWrapped(Storage<FluidVariant> wrapped) {
            this.wrapped = wrapped;
        }
    }
}

