/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.world.data;

import bigchadguys.dailyshop.DailyShopMod;
import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.init.ModConfigs;
import bigchadguys.dailyshop.init.ModNetwork;
import bigchadguys.dailyshop.init.ModWorldData;
import bigchadguys.dailyshop.net.DailyShopUpdateS2CPacket;
import bigchadguys.dailyshop.trade.EmptyShop;
import bigchadguys.dailyshop.trade.Shop;
import bigchadguys.dailyshop.world.data.WorldData;
import bigchadguys.dailyshop.world.random.JavaRandom;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class DailyShopData
extends WorldData {
    public static final DailyShopData CLIENT = new DailyShopData();
    private Shop shop = EmptyShop.INSTANCE;
    private long lastUpdated;

    public Shop getShop() {
        return this.shop;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setShop(Shop shop, MinecraftServer server) {
        this.shop = shop;
        this.shop.setChangeListener(this, () -> this.onChanged(server));
        this.lastUpdated = System.currentTimeMillis();
        this.onChanged(server);
    }

    public void reset() {
        this.lastUpdated = 0L;
        this.method_78(true);
    }

    public void onTick(MinecraftServer server) {
        if (ModConfigs.DAILY_SHOP.shouldUpdate(this.lastUpdated)) {
            this.setShop(ModConfigs.DAILY_SHOP.generate(JavaRandom.ofNanoTime()), server);
            DailyShopMod.LOGGER.info("Refreshed daily shop!");
        }
    }

    public void onChanged(MinecraftServer server) {
        this.method_78(true);
        if (server != null) {
            for (class_3222 player : server.method_3760().method_14571()) {
                this.sendUpdatesToClient(player);
            }
        }
    }

    private void sendUpdatesToClient(class_3222 player) {
        ModNetwork.CHANNEL.sendToPlayer(player, (Object)new DailyShopUpdateS2CPacket(this.shop));
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        Adapters.SHOP.writeNbt(this.shop).ifPresent(value -> nbt.method_10566("shop", value));
        Adapters.LONG.writeNbt(this.lastUpdated).ifPresent(value -> nbt.method_10566("lastUpdated", value));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.shop = Adapters.SHOP.readNbt(nbt.method_10580("shop")).orElse(null);
        this.lastUpdated = Adapters.LONG.readNbt(nbt.method_10580("lastUpdated")).orElse(0L);
    }

    public static void initCommon() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            DailyShopData data = ModWorldData.DAILY_SHOP.getGlobal((class_1937)player.method_51469());
            data.sendUpdatesToClient(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            DailyShopData data = ModWorldData.DAILY_SHOP.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

