/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.util;

import bigchadguys.dailyshop.world.random.RandomSource;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;

public class WeightedList<T>
extends AbstractMap<T, Double> {
    private static final WeightedList<?> EMPTY = new WeightedList();
    private final Map<T, Double> delegate = new LinkedHashMap<T, Double>();

    public static <T> T empty() {
        return (T)EMPTY;
    }

    public <J extends JsonElement> Optional<JsonElement> writeJson(Function<T, Optional<J>> serializer) {
        if (this.delegate.isEmpty()) {
            return Optional.of(JsonNull.INSTANCE);
        }
        if (this.delegate.size() == 1) {
            return serializer.apply(this.delegate.keySet().iterator().next());
        }
        JsonArray array = new JsonArray();
        for (Map.Entry<T, Double> entry : this.delegate.entrySet()) {
            JsonObject object;
            JsonElement element = serializer.apply(entry.getKey()).orElse(null);
            if (element == null) continue;
            if (element instanceof JsonObject) {
                object = (JsonObject)element;
            } else {
                object = new JsonObject();
                object.add("value", element);
            }
            object.addProperty("weight", (Number)entry.getValue());
            array.add((JsonElement)object);
        }
        return Optional.of(array);
    }

    public <J extends JsonElement> void readJson(JsonElement json, Function<J, Optional<T>> deserializer) {
        this.clear();
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            if (object.has("value")) {
                deserializer.apply(object.get("value")).ifPresent(value -> this.put(value, object.get("weight").getAsDouble()));
            } else {
                deserializer.apply(object).ifPresent(value -> this.put(value, object.has("weight") ? object.get("weight").getAsDouble() : 1.0));
            }
        } else if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            for (JsonElement element : array) {
                JsonObject object = element.getAsJsonObject();
                if (object.has("value")) {
                    deserializer.apply(object.get("value")).ifPresent(value -> this.put(value, object.get("weight").getAsDouble()));
                    continue;
                }
                deserializer.apply(object).ifPresent(value -> this.put(value, object.get("weight").getAsDouble()));
            }
        }
    }

    public <J extends JsonElement> void readJson(JsonElement json, Supplier<T> constructor, BiConsumer<T, J> deserializer) {
        this.clear();
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            T value = constructor.get();
            if (object.has("value")) {
                deserializer.accept(value, object.get("value"));
            } else {
                deserializer.accept(value, object);
            }
            this.put(value, object.has("weight") ? object.get("weight").getAsDouble() : 1.0);
        } else if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            for (JsonElement element : array) {
                JsonObject object = element.getAsJsonObject();
                T value = constructor.get();
                if (object.has("value")) {
                    deserializer.accept(value, object.get("value"));
                } else {
                    deserializer.accept(value, object);
                }
                this.put(value, object.get("weight").getAsDouble());
            }
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<T, Double>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Double put(T value, Double weight) {
        return this.delegate.put(value, weight);
    }

    @Override
    public Double put(T value, Number weight) {
        return this.put(value, weight.doubleValue());
    }

    public WeightedList<T> add(T value, Double weight) {
        double current = this.getOrDefault(value, 0.0);
        this.put(value, current + weight);
        return this;
    }

    public WeightedList<T> add(T value, Number weight) {
        return this.add(value, weight.doubleValue());
    }

    public double getTotalWeight() {
        double sum = 0.0;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            double weight = (Double)iterator.next();
            sum += Math.max(weight, 0.0);
        }
        return sum;
    }

    public Optional<T> getRandom() {
        return this.getRandom(new Random());
    }

    public Optional<T> getRandom(RandomGenerator random) {
        return this.getRandom(random::nextDouble);
    }

    public Optional<T> getRandom(RandomSource random) {
        return this.getRandom(random::nextDouble);
    }

    public Optional<T> getRandom(DoubleUnaryOperator random) {
        double total = this.getTotalWeight();
        if (total <= 0.0) {
            return Optional.empty();
        }
        double index = random.applyAsDouble(total);
        for (Map.Entry<T, Double> entry : this.delegate.entrySet()) {
            T value = entry.getKey();
            double weight = Math.max(entry.getValue(), 0.0);
            if (index < weight) {
                return Optional.ofNullable(value);
            }
            index -= weight;
        }
        return Optional.empty();
    }
}

