/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.trade;

import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import bigchadguys.dailyshop.data.item.ItemPredicate;
import bigchadguys.dailyshop.data.item.PartialItem;
import bigchadguys.dailyshop.data.item.PartialItemGroup;
import bigchadguys.dailyshop.data.item.PartialItemTag;
import bigchadguys.dailyshop.data.item.PartialStack;
import bigchadguys.dailyshop.data.serializable.ISerializable;
import bigchadguys.dailyshop.data.tile.OrItemPredicate;
import bigchadguys.dailyshop.init.ModBlocks;
import bigchadguys.dailyshop.init.ModConfigs;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7923;

public class Trade
implements ISerializable<class_2487, JsonObject> {
    public static final Trade ERROR = new Trade(new Input(PartialItem.of(((class_2248)ModBlocks.ERROR.get()).method_8389()), 1), new Input(PartialItem.of(((class_2248)ModBlocks.ERROR.get()).method_8389()), 1), new Input(PartialItem.of(((class_2248)ModBlocks.ERROR.get()).method_8389()), 1), new class_1799((class_1935)((class_2248)ModBlocks.ERROR.get()).method_8389()), 0, 0);
    private final Input input1;
    private final Input input2;
    private final Input input3;
    private class_1799 output;
    private int currentTrades;
    private int maximumTrades;

    public Trade() {
        this.input1 = new Input();
        this.input2 = new Input();
        this.input3 = new Input();
    }

    public Trade(Input input1, Input input2, Input input3, class_1799 output, int currentTrades, int maximumTrades) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.output = output;
        this.currentTrades = currentTrades;
        this.maximumTrades = maximumTrades;
    }

    public Input getInput(int index) {
        return switch (index) {
            case 1 -> this.input1;
            case 2 -> this.input2;
            case 3 -> this.input3;
            default -> throw new IllegalArgumentException("Invalid index: " + index);
        };
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public boolean isAvailable() {
        return this.maximumTrades < 0 || this.currentTrades < this.maximumTrades;
    }

    public void onTrade(int count) {
        this.currentTrades += count;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        this.input1.writeBits(buffer);
        this.input2.writeBits(buffer);
        this.input3.writeBits(buffer);
        Adapters.ITEM_STACK.writeBits(this.output, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.currentTrades, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.maximumTrades, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.input1.readBits(buffer);
        this.input2.readBits(buffer);
        this.input3.readBits(buffer);
        this.output = Adapters.ITEM_STACK.readBits(buffer).orElseThrow();
        this.currentTrades = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.maximumTrades = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        this.input1.writeNbt().ifPresent(value -> nbt.method_10566("input1", (class_2520)value));
        this.input2.writeNbt().ifPresent(value -> nbt.method_10566("input2", (class_2520)value));
        this.input3.writeNbt().ifPresent(value -> nbt.method_10566("input3", (class_2520)value));
        Adapters.ITEM_STACK.writeNbt(this.output).ifPresent(value -> nbt.method_10566("output", value));
        Adapters.INT_SEGMENTED_3.writeNbt(this.currentTrades).ifPresent(value -> nbt.method_10566("currentTrades", value));
        Adapters.INT_SEGMENTED_3.writeNbt(this.maximumTrades).ifPresent(value -> nbt.method_10566("maximumTrades", value));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.input1.readNbt(nbt.method_10562("input1"));
        this.input2.readNbt(nbt.method_10562("input2"));
        this.input3.readNbt(nbt.method_10562("input3"));
        this.output = Adapters.ITEM_STACK.readNbt(nbt.method_10580("output")).orElseThrow();
        this.currentTrades = (Integer)Adapters.INT_SEGMENTED_3.readNbt(nbt.method_10580("currentTrades")).orElseThrow();
        this.maximumTrades = (Integer)Adapters.INT_SEGMENTED_3.readNbt(nbt.method_10580("maximumTrades")).orElseThrow();
    }

    public static class Input
    implements ISerializable<class_2487, JsonObject> {
        private ItemPredicate filter;
        private int count;
        private List<Entry> cache;

        public Input() {
        }

        public Input(ItemPredicate filter, int count) {
            this.filter = filter;
            this.count = count;
        }

        public ItemPredicate getFilter() {
            return this.filter;
        }

        public int getCount() {
            return this.count;
        }

        public class_1799 getDisplay(double time) {
            if (this.cache == null) {
                this.cache = new ArrayList<Entry>();
                this.iterate(this.filter, new class_2487(), this.cache);
            }
            if (this.cache.isEmpty()) {
                return new class_1799((class_1935)class_1802.field_8162, this.count);
            }
            int index = (int)(time / 30.0) % this.cache.size();
            return this.cache.get(index).toStack(this.count);
        }

        private void iterate(ItemPredicate filter, class_2487 nbt, List<Entry> entries) {
            if (filter instanceof OrItemPredicate) {
                OrItemPredicate or = (OrItemPredicate)filter;
                for (ItemPredicate predicate : or.getChildren()) {
                    this.iterate(predicate, nbt, entries);
                }
            } else if (filter instanceof PartialItem) {
                PartialItem item = (PartialItem)filter;
                entries.add(new Entry(item.asWhole().orElse(((class_2248)ModBlocks.ERROR.get()).method_8389()), null));
            } else if (filter instanceof PartialItemGroup) {
                PartialItemGroup group = (PartialItemGroup)filter;
                for (ItemPredicate child : ModConfigs.ITEM_GROUPS.getGroup(group.getId())) {
                    class_2487 copy = nbt.method_10553();
                    group.getNbt().asWhole().ifPresent(arg_0 -> ((class_2487)copy).method_10543(arg_0));
                    this.iterate(child, copy, entries);
                }
            } else if (filter instanceof PartialItemTag) {
                PartialItemTag tag = (PartialItemTag)filter;
                class_2487 copy = nbt.method_10553();
                tag.getNbt().asWhole().ifPresent(arg_0 -> ((class_2487)copy).method_10543(arg_0));
                for (class_1792 item : class_7923.field_41178) {
                    if (!class_7923.field_41178.method_47983((Object)item).method_40228().anyMatch(itemTagKey -> tag.getId().equals((Object)itemTagKey.comp_327()))) continue;
                    entries.add(new Entry(item, copy));
                }
            } else if (filter instanceof PartialStack) {
                PartialStack stack = (PartialStack)filter;
                class_1799 _stack = stack.generate(this.count).orElseGet(() -> new class_1799((class_1935)((class_2248)ModBlocks.ERROR.get()).method_8389(), this.count));
                entries.add(new Entry(_stack.method_7909(), _stack.method_7969()));
            }
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.ITEM_PREDICATE.writeBits(this.filter, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.filter = Adapters.ITEM_PREDICATE.readBits(buffer).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<class_2487> writeNbt() {
            class_2487 nbt = new class_2487();
            Adapters.ITEM_PREDICATE.writeNbt(this.filter).ifPresent(value -> nbt.method_10566("filter", value));
            Adapters.INT_SEGMENTED_3.writeNbt(this.count).ifPresent(value -> nbt.method_10566("count", value));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.filter = Adapters.ITEM_PREDICATE.readNbt(nbt.method_10580("filter")).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readNbt(nbt.method_10580("count")).orElseThrow();
        }

        private record Entry(class_1792 item, class_2487 nbt) {
            public class_1799 toStack(int count) {
                class_1799 stack = new class_1799((class_1935)this.item, count);
                stack.method_7980(this.nbt);
                return stack;
            }
        }
    }
}

