/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.trade;

import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import bigchadguys.dailyshop.trade.Shop;
import bigchadguys.dailyshop.trade.Trade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ArrayShop
extends Shop {
    private final List<Trade> trades = new ArrayList<Trade>();

    public ArrayShop() {
    }

    public ArrayShop(Collection<Trade> trades) {
        this();
        this.trades.addAll(trades);
    }

    @Override
    public Stream<Trade> getTrades() {
        return this.trades.stream();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_3.writeBits(this.trades.size(), buffer);
        for (Trade trade : this.trades) {
            trade.writeBits(buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.trades.clear();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            Trade trade = new Trade();
            trade.readBits(buffer);
            this.trades.add(trade);
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        for (Trade trade : this.trades) {
            trade.writeNbt().ifPresent(arg_0 -> list.add(arg_0));
        }
        nbt.method_10566("trades", (class_2520)list);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.trades.clear();
        class_2499 list = nbt.method_10554("trades", 10);
        for (class_2520 element : list) {
            if (!(element instanceof class_2487)) continue;
            class_2487 compound = (class_2487)element;
            Trade trade = new Trade();
            trade.readNbt(compound);
            this.trades.add(trade);
        }
    }
}

