/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.tile;

import bigchadguys.dailyshop.data.nbt.PartialCompoundNbt;
import bigchadguys.dailyshop.data.tile.PartialBlockProperties;
import bigchadguys.dailyshop.data.tile.PartialBlockState;
import bigchadguys.dailyshop.data.tile.TilePlacement;
import bigchadguys.dailyshop.init.ModConfigs;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class PartialBlockGroup
implements TilePlacement<PartialBlockGroup> {
    private class_2960 id;
    private PartialBlockProperties properties;
    private PartialCompoundNbt entity;

    public PartialBlockGroup(class_2960 id, PartialBlockProperties properties, PartialCompoundNbt entity) {
        this.id = id;
        this.properties = properties;
        this.entity = entity;
    }

    public static PartialBlockGroup of(class_2960 id, PartialBlockProperties properties, PartialCompoundNbt entity) {
        return new PartialBlockGroup(id, properties, entity);
    }

    @Override
    public boolean isSubsetOf(PartialBlockGroup other) {
        return (this.id == null || this.id.equals((Object)other.id)) && this.properties.isSubsetOf(other.properties) && this.entity.isSubsetOf(other.entity);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillInto(PartialBlockGroup other) {
        if (this.id != null) {
            other.id = this.id;
        }
        this.properties.fillInto(other.properties);
        this.entity.fillInto(other.entity);
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        this.properties.place(world, pos, flags);
        this.entity.place(world, pos, flags);
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.properties.isSubsetOf(state.getProperties()) && this.entity.isSubsetOf(nbt) && ModConfigs.TILE_GROUPS.isInGroup(this.id, state, nbt);
    }

    @Override
    public PartialBlockGroup copy() {
        return new PartialBlockGroup(this.id, this.properties.copy(), this.entity.copy());
    }

    public String toString() {
        return (String)(this.id != null ? "@" + this.id : "") + this.properties.toString() + this.entity.toString();
    }

    public static Optional<PartialBlockGroup> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlockGroup.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlockGroup parse(String string) throws CommandSyntaxException {
        return PartialBlockGroup.parse(new StringReader(string));
    }

    public static PartialBlockGroup parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '@') {
            throw new IllegalArgumentException("Invalid block group '" + reader.getString() + "' does not start with @");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBlockGroup.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBlockGroup.of(new class_2960(string), PartialBlockProperties.parse(reader), PartialCompoundNbt.parse(reader));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid group identifier '" + string + "' in block group '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

