/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.adapter.number;

import bigchadguys.dailyshop.data.adapter.number.NumberAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class DoubleAdapter
extends NumberAdapter<Double> {
    public DoubleAdapter(boolean nullable) {
        super(nullable);
    }

    public DoubleAdapter asNullable() {
        return new DoubleAdapter(true);
    }

    @Override
    protected void writeNumberBits(Double value, BitBuffer buffer) {
        buffer.writeDouble(value);
    }

    @Override
    protected Double readNumberBits(BitBuffer buffer) {
        return buffer.readDouble();
    }

    @Override
    protected void writeNumberBytes(Double value, ByteBuf buffer) {
        buffer.writeDouble(value.doubleValue());
    }

    @Override
    protected Double readNumberBytes(ByteBuf buffer) {
        return buffer.readDouble();
    }

    @Override
    protected void writeNumberData(Double value, DataOutput data) throws IOException {
        data.writeDouble(value);
    }

    @Override
    protected Double readNumberData(DataInput data) throws IOException {
        return data.readDouble();
    }

    @Override
    protected class_2520 writeNumberNbt(Double value) {
        return DoubleAdapter.wrap(DoubleAdapter.reduce(value));
    }

    @Override
    protected Double readNumberNbt(class_2520 nbt) {
        class_2499 list;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return numeric.method_10697();
        }
        if (nbt instanceof class_2499 && (list = (class_2499)nbt).size() == 1) {
            return this.readNumberNbt(list.method_10534(0));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return DoubleAdapter.parse(string.method_10714()).map(Number::doubleValue).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(Double value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    protected Double readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            if (primitive.isString()) {
                return DoubleAdapter.parse(primitive.getAsString()).map(Number::doubleValue).orElse(null);
            }
        }
        return null;
    }
}

