/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.adapter.number;

import bigchadguys.dailyshop.data.adapter.ISimpleAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_2481;
import net.minecraft.class_2520;

public class BooleanAdapter
implements ISimpleAdapter<Boolean, class_2520, JsonElement> {
    private final boolean nullable;

    public BooleanAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public BooleanAdapter asNullable() {
        return new BooleanAdapter(true);
    }

    @Override
    public final void writeBits(Boolean value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeBoolean(value);
        }
    }

    @Override
    public final Optional<Boolean> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readBoolean());
    }

    @Override
    public final void writeBytes(Boolean value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeBoolean(value.booleanValue());
        }
    }

    @Override
    public final Optional<Boolean> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readBoolean());
    }

    @Override
    public void writeData(Boolean value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeBoolean(value);
        }
    }

    @Override
    public Optional<Boolean> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(data.readBoolean());
    }

    @Override
    public final Optional<class_2520> writeNbt(Boolean value) {
        return value == null ? Optional.empty() : Optional.of(class_2481.method_23234((boolean)value));
    }

    @Override
    public final Optional<Boolean> readNbt(class_2520 nbt) {
        class_2481 tag;
        return nbt instanceof class_2481 ? Optional.of((tag = (class_2481)nbt).method_10698() != 0) : Optional.empty();
    }

    @Override
    public final Optional<JsonElement> writeJson(Boolean value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value));
    }

    @Override
    public final Optional<Boolean> readJson(JsonElement json) {
        JsonPrimitive primitive;
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readJson(array.get(0));
        }
        if (json instanceof JsonPrimitive && !(primitive = (JsonPrimitive)json).isBoolean()) {
            try {
                return Optional.of(primitive.getAsBoolean());
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

