/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.config;

import bigchadguys.dailyshop.config.Config;
import bigchadguys.dailyshop.config.FileConfig;
import bigchadguys.dailyshop.init.ModConfigs;
import bigchadguys.dailyshop.trade.ArrayShop;
import bigchadguys.dailyshop.trade.ReferenceTradeEntry;
import bigchadguys.dailyshop.trade.Shop;
import bigchadguys.dailyshop.trade.TradeEntry;
import bigchadguys.dailyshop.world.random.RandomSource;
import com.google.gson.annotations.Expose;

public class DailyShopConfig
extends FileConfig {
    @Expose
    private long startEpoch;
    @Expose
    private long refreshDelay;
    @Expose
    private TradeEntry trades;

    public boolean shouldUpdate(long lastUpdated) {
        long refreshes = (lastUpdated - this.startEpoch) / this.refreshDelay;
        long nextRefresh = this.startEpoch + (refreshes + 1L) * this.refreshDelay;
        return System.currentTimeMillis() >= nextRefresh;
    }

    public Shop generate(RandomSource random) {
        return new ArrayShop(this.trades.generate(random).toList());
    }

    public void validate(String path) {
        this.trades.validate(path + ".trades");
    }

    @Override
    public String getPath() {
        return "daily_shop";
    }

    @Override
    protected void reset() {
        this.startEpoch = 0L;
        this.refreshDelay = 60000L;
        this.trades = new ReferenceTradeEntry("daily_shop");
    }

    @Override
    public <T extends Config> T read() {
        Object config = super.read();
        ModConfigs.POST_LOAD.add(() -> ((DailyShopConfig)config).validate(this.getPath()));
        return config;
    }
}

