/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.block.entity;

import bigchadguys.dailyshop.block.entity.BaseBlockEntity;
import bigchadguys.dailyshop.init.ModBlocks;
import bigchadguys.dailyshop.init.ModWorldData;
import bigchadguys.dailyshop.screen.handler.DailyShopScreenHandler;
import bigchadguys.dailyshop.trade.Shop;
import bigchadguys.dailyshop.world.data.DailyShopData;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class DailyShopBlockEntity
extends BaseBlockEntity
implements class_1278,
ExtendedMenuProvider {
    public static final int[] AVAILABLE_SLOTS = IntStream.range(0, 27).toArray();
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private long lastUpdated;
    private boolean refreshed = false;

    public DailyShopBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlocks.Entities.DAILY_SHOP.get(), pos, state);
    }

    public DailyShopBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
        this.sendUpdatesToClient();
    }

    private void setRefreshed(boolean refreshed) {
        this.refreshed = refreshed;
        this.sendUpdatesToClient();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DailyShopBlockEntity entity) {
        DailyShopData data;
        if (world instanceof class_3218 && (data = ModWorldData.DAILY_SHOP.getGlobal(world)).getLastUpdated() != entity.lastUpdated) {
            entity.setLastUpdated(data.getLastUpdated());
            entity.setRefreshed(true);
        }
    }

    @Override
    public void writeNbt(class_2487 nbt, BaseBlockEntity.UpdateType type) {
        class_2499 inventory = new class_2499();
        for (int slotIndex = 0; slotIndex < this.inventory.size(); ++slotIndex) {
            class_1799 stack = (class_1799)this.inventory.get(slotIndex);
            if (stack.method_7960()) continue;
            class_2487 entry = new class_2487();
            stack.method_7953(entry).method_10567("slot", (byte)slotIndex);
            inventory.add((Object)entry);
        }
        if (!inventory.isEmpty()) {
            nbt.method_10566("inventory", (class_2520)inventory);
        }
        if (this.refreshed) {
            nbt.method_10556("refreshed", true);
        }
    }

    @Override
    public void readNbt(class_2487 nbt, BaseBlockEntity.UpdateType type) {
        this.inventory.clear();
        class_2499 inventory = nbt.method_10554("inventory", 10);
        for (int i = 0; i < inventory.size(); ++i) {
            class_2487 entry = inventory.method_10602(i);
            int slotIndex = Byte.toUnsignedInt(entry.method_10571("slot"));
            if (slotIndex >= this.inventory.size()) continue;
            this.inventory.set(i, (Object)class_1799.method_7915((class_2487)entry));
        }
        this.refreshed = nbt.method_10577("refreshed");
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public int[] method_5494(class_2350 side) {
        return AVAILABLE_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.daily_shop");
    }

    public void method_5435(class_1657 player) {
        this.setRefreshed(false);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        Shop shop = ModWorldData.DAILY_SHOP.getGlobal(player.method_37908()).getShop();
        return new DailyShopScreenHandler(syncId, playerInventory, (class_1263)this, shop);
    }

    public void saveExtraData(class_2540 buf) {
    }
}

