/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class FilterSettingsBase {
    protected List<class_1799> filterItems;
    protected List<String> filterTags = new ArrayList<String>();
    protected List<class_6862<class_1792>> tags = new ArrayList<class_6862<class_1792>>();
    protected List<Integer> filterSettings;
    protected ItemStackHandler storage;
    private final int slotLimit;

    public FilterSettingsBase(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings, int slotLimit) {
        this(storage, items, filterSettings, List.of(), slotLimit);
    }

    public FilterSettingsBase(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings, List<String> filterTags, int slotLimit) {
        this.filterItems = items;
        this.filterTags = filterTags;
        this.filterSettings = filterSettings;
        this.storage = storage;
        this.slotLimit = slotLimit;
        this.reloadItemTags();
    }

    public abstract boolean matchesFilter(@Nullable class_1657 var1, class_1799 var2);

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean isTagFilter() {
        return false;
    }

    public boolean compareModId(class_1799 stack, class_1799 other) {
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals(class_7923.field_41178.method_10221((Object)other.method_7909()).method_12836());
    }

    public Stream<class_1799> streamStorageContents() {
        ArrayList<class_1799> arrayList = new ArrayList<class_1799>();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            if (this.storage.getStackInSlot(i).method_7960()) continue;
            arrayList.add(this.storage.getStackInSlot(i));
        }
        return arrayList.stream();
    }

    public void reloadItemTags() {
        this.tags.clear();
        if (this.filterTags != null) {
            this.filterTags.forEach(string -> {
                class_2960 tag = class_2960.method_12829((String)string);
                if (tag == null) {
                    return;
                }
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tag);
                if (!this.tags.contains(tagKey)) {
                    this.tags.add((class_6862<class_1792>)tagKey);
                }
            });
        }
    }

    public void updateFilter(@Nullable List<class_1799> items) {
        if (items == null) {
            return;
        }
        this.filterItems = items.stream().limit(this.slotLimit).filter(stack -> !stack.method_7960()).toList();
    }

    public void updateFilterTags(List<String> tags) {
        if (tags == null) {
            return;
        }
        this.filterTags = new ArrayList<String>(tags);
        this.reloadItemTags();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }

    public List<class_1799> getFilterItems() {
        return this.filterItems;
    }

    public List<String> getFilterTags() {
        return this.filterTags;
    }

    public List<String> getAddableTags() {
        ArrayList<String> addableTags = new ArrayList<String>();
        class_1799 stack = class_1799.field_8037;
        if (this.filterItems != null && !this.filterItems.isEmpty()) {
            stack = this.filterItems.get(0);
        }
        if (!stack.method_7960()) {
            stack.method_40133().forEach(tag -> addableTags.add(tag.comp_327().toString()));
        }
        addableTags.removeAll(this.filterTags);
        return addableTags;
    }
}

